#!/usr/bin/awk
#argument -F "," -v key=<Timestamp match column>
BEGIN {
	ctr=0;
	ts="dummy";
	printf("TimeStamp,AveTemp[C],AveHumi[%%RH],MinTemp[C],MinHumi[%%RH],MaxTemp[C],MaxHumi[%%RH],DataCount\n");
}
/\"/ {
	ts=$1;
	temp=$2;
	humi=$3;

	if (substr(ts,1,key) != substr(dt,1,key)) {
		if (ctr > 0) {
			t=tsum/ctr;
			h=hsum/ctr;
			printf("%s, %2.1f, %2d, %2.1f, %2d, %2.1f, %2d, %d\n", dt, t, h, tmin, hmin, tmax, hmax, ctr);
		}
		ctr=0;
		tsum=0;
		hsum=0;
		tmin=temp;
		hmin=humi;
		tmax=temp;
		hmax=humi;
		dt=ts;
	}

	ctr++;
	tsum=tsum+temp;
	hsum=hsum+humi;
	if (tmin > temp) {
		tmin=temp;
	}
	if (hmin > humi) {
		hmin=humi;
	}
	if (tmax < temp) {
		tmax=temp;
	}
	if (max < humi) {
		hmax=humi;
	}

} 
END {
	if (ctr > 0) {
		t=tsum/ctr;
		h=hsum/ctr;
		printf("%s, %2.1f, %2d, %2.1f, %2d, %2.1f, %2d, %d\n", dt, t, h, tmin, hmin, tmax, hmax, ctr);
	}
}
