//
//  bt_att_server.h
//
//  Bluetooth Protocol Stack - Attribute Server
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 4.0
//          Volume 3: Core System Package [Host volume]
//          PartF: Attribute Protocol (ATT)
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.03.25 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2013.04.25 v0.1  WRITE,NOTIFICATION,INDICATION support
//  2013.12.12 v0.1a Add the API
//  2017.01.03 v0.3e argument handle -> cb_channel
//
#ifndef BT_ATT_SERVER_H_
#define BT_ATT_SERVER_H_

#include <string.h>
#include "bt_l2cap_cb_channel.h"        // Channel manage table     ADD 2017.01.03

//
//  ATT Server event process
//
extern size_t bt_attServer(
//      unsigned short  handle,         // Communication handle     DEL 2017.01.03
        struct bt_l2capChannel *ch,     // Control block            ADD 2017.01.03
        unsigned char  *in,             // Request Reveive data
        size_t          inLen,          //
        unsigned char  *out,            // Response Send data
        size_t          maxSize         // out area size
);

//
//  API
//
extern void bt_att_serverNotificationQueueAdd(unsigned short handle);   // ADD 2013.12.12  Send request

#endif /* BT_ATT_SERVER_H_ */
