//
//  bt_l2cap_cb_device.h
//
//  Bluetooth Protocol Stack - Remote BT controller device management control block operation
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2013.05.08 v0.1  Changed a control block structure
//  2015.02.06 v0.3a Supported the Secure Simple Pairing
//  2016.04.21 v0.3d Appended a API for SSP
//  2017.01.08 v0.3e Appended a authentication function for the classic services
//  2017.01.18 v0.3f Appended a authentication function for the SM
//
#ifndef BT_L2CAP_CB_DEVICE_H_
#define BT_L2CAP_CB_DEVICE_H_

#include <time.h>                               // ADD 2016.04.21

//
//  Control block
//
struct bt_l2capDevice {
    struct bt_l2capDevice  *next;
    unsigned char           bdAddr[6];
    unsigned char           addrType;           // ADD 2017.01.18  LE
    unsigned char           linkKey[16];        // SSP
    unsigned char           keyType;            // SSP

//  unsigned char           peerAddressType;    // DEL 2017.01.18  LE
//  unsigned char           peerAddress[6];     // LE  -> bdAddr
    unsigned char           ioCapability;       // ADD 2015.02.06  SSP IO Capability (peer)
    unsigned char           oobDataPresent;     // ADD 2015.02.06  SSP IO Capability (peer)
    unsigned char           authentication;     // ADD 2015.02.06  SSP IO Capability (peer)
    long                    numericValue;       // ADD 2017.01.08  SSP Passkey or Numeric comparison
//  unsigned long           numericValue;       // ADD 2015.02.06  DEL 2017.01.08  SSP
//  unsigned char           pinCode[16];        // ADD 2016.04.21  DEL 2017.01.08  SSP
    time_t                  passkeyInput;       // ADD 2016.04.21
    time_t                  numericInput;       // ADD 2016.04.21

    unsigned char           ediv[2];            // ADD 2017.01.18  SM Bonding data
    unsigned char           rand[8];            // ADD 2017.01.18  SM Bonding data
//  unsigned char           ltk[16];            // ADD 2017.01.18  SM Making from the Rand+EDIV
//  unsigned char           irk[16];            // ADD 2017.01.18  SM Making from the Rand+EDIV
//  unsigned char           csrk[16];           // ADD 2017.01.18  SM Making from the Rand+EDIV
    unsigned char           auth;               // ADD 2017.01.18  SM Bonding data
//  unsigned char           initEdiv[2];        // ADD 2017.01.18  SM Bonding data (peer)
//  unsigned char           initRand[8];        // ADD 2017.01.18  SM Bonding data (peer)
//  unsigned char           initLtk[16];        // ADD 2017.01.18  SM Bonding data (peer)
    unsigned char           initIrk[16];        // ADD 2017.01.18  SM Bonding data (peer)
//  unsigned char           initCsrk[16];       // ADD 2017.01.18  SM Bonding data (peer)

    unsigned char           bdAddrValid;
    unsigned char           linkKeyValid;
#ifdef DELETE                                   // DEL START 2017.01.08
    unsigned char           sspValid;           // ADD 2015.02.06  Secure Simple Pairing
    unsigned char           pinCodeLen;         // ADD 2016.04.21
    char                   *name;
#endif                                          // DEL END 2017.01.08
};

//
//  API
//
extern struct bt_l2capDevice   *bt_l2capDeviceGetNext(struct bt_l2capDevice **id);  // ADD 2015.02.03
extern struct bt_l2capDevice   *bt_l2capDeviceFind(unsigned char *bdAddr);
extern struct bt_l2capDevice   *bt_l2capDeviceAdd(unsigned char *bdAddr);
extern void                     bt_l2capDeviceDelete(struct bt_l2capDevice *p);
extern void                     bt_l2capDeviceClear(void);                          // ADD 2015.02.03

#endif /* BT_L2CAP_CB_DEVICE_H_ */
