//
//  bt_process.c
//
//  Bluetooth Protocol Stack - Process scheduler
//  Copyright (C) 2013-2015 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 4.0
//          Volume 3: Core System Package [Host volume]
//          Part A: Logical Link Control and Adaptation Protocol Specification
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2014.03.05 v0.2  Change the USB process calling
//  2015.03.03 v0.3b Concealment of bluetooth task to the user
//
#include "bt_l2cap_resource_manager.h"

void bt_init(void){                     // ADD 2014.03.05
    bt_l2capResourceManager(0);         // ADD 2014.03.05
}                                       // ADD 2014.03.05

int bt_process(void){
    int rc;

    // L2CAP
//  rc = bt_l2capResourceManager();     // CHG 2014.03.05
    rc = bt_l2capResourceManager(1);    // CHG 2014.03.05

    return(rc);
}

void bt_deinit(void){                   // ADD 2015.03.03
    bt_l2capResourceManager(0);         // ADD 2015.03.03
}                                       // ADD 2015.03.03
