//
//  bt_sdp_data.c
//
//  Bluetooth Protocol Stack - SDP Service Database
//  Copyright (C) 2017-2018 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 2.0 + EDR
//          Volume 3: Core System Package [Host volume]
//          PartB: Service Discovery Protocol (SDP) Specification
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2017.03.10 v0.4  Supported an AVDTP
//  2018.02.10 v0.4a Bug fix
//
#include "bt_spec_sdp.h"
#include "bt_spec_gatt.h"
#include "bt_spec_l2cap.h"
#include "bt_sdp_server.h"
#include "bt_config.h"

const unsigned char bt_sdpMasterRecord1[] = {
  SDP_DATA_ELEMENT16_3(92),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceRecordHandle),           SDP_DATA_UINT32_5(0x10010),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_BrowseGroupList),               SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_PublicBrowseRoot),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceClassIDList),            SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_SerialPort),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceName),                   SDP_DATA_STRING8, 11, 'S', 'e', 'r', 'i', 'a', 'l', ' ', 'P', 'o', 'r', 't',
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ProtocolDescriptorList),        SDP_DATA_ELEMENT8_2(12),
                                                                        SDP_DATA_ELEMENT8_2(3),         // Protocol#0
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_L2CAP),
                                                                        SDP_DATA_ELEMENT8_2(5),         // Protocol#1
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_RFCOMM),
                                                                            SDP_DATA_UINT8_2(1),        // Server Channel# 1..30
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_BluetoothProfileDescriptorList),SDP_DATA_ELEMENT8_2(8),
                                                                        SDP_DATA_ELEMENT8_2(6),         // Profile#0
                                                                            SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_SerialPort),    // Supported Profiles
                                                                            SDP_DATA_UINT16_3(0x0102),  // Profile Version
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_LanguageBaseAttributeIDList),   SDP_DATA_ELEMENT8_2(9),
                                                                        SDP_DATA_UINT16, 'e', 'n',      // Language code: ISO639: english
                                                                        SDP_DATA_UINT16_3(106),         // Encode: IANA's database: UTF-8
                                                                        SDP_DATA_UINT16_3(0x0100),      // ?
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceRecordState),            SDP_DATA_UINT32_5(15),
};

const unsigned char bt_sdpMasterRecord2[] = {
  SDP_DATA_ELEMENT16_3(57),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceRecordHandle),           SDP_DATA_UINT32_5(0x10020),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_BrowseGroupList),               SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_PublicBrowseRoot),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceClassIDList),            SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(GATT_Services_Generic_Access_Profile),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceName),                   SDP_DATA_STRING8, 4, 'G', 'A', 'T', 'T',
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ProtocolDescriptorList),        SDP_DATA_ELEMENT8_2(19),
                                                                        SDP_DATA_ELEMENT8_2(6),         // Protocol#0
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_L2CAP),
                                                                            SDP_DATA_UINT16_3(L2CAP_PDU_PSM_ATT),
                                                                        SDP_DATA_ELEMENT8_2(9),         // Protocol#1
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_ATT),
                                                                            SDP_DATA_UINT16_3(0x0000),  //     Start handle
                                                                            SDP_DATA_UINT16_3(0xffff),  //     End handle
};

const unsigned char bt_sdpMasterRecord3[] = {
  SDP_DATA_ELEMENT16_3(72),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceRecordHandle),           SDP_DATA_UINT32_5(0x10030),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_BrowseGroupList),               SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_PublicBrowseRoot),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceClassIDList),            SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_PnPInformation),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceDescription),            SDP_DATA_STRING8, 8, 'P', 'n', 'P', ' ', 'I', 'n', 'f', 'o',
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_SpecificationID),           SDP_DATA_UINT16_3(SDP_DID_SpecificationID),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_PrimaryRecord),             SDP_DATA_BOOL8_2_TRUE,
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_VenderIDSource),            SDP_DATA_UINT16_3(SDP_DID_VenderIDSource_USB),
#if defined(USE_STM32F4_DISCOVERY)
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_VendorID),                  SDP_DATA_UINT16_3(0x0483),  // STM
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_ProductID),                 SDP_DATA_UINT16_3(0x5740),  //   STM32F407
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_Version),                   SDP_DATA_UINT16_3(0x0031),  //     v0.3.1
#else
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_VendorID),                  SDP_DATA_UINT16_3(0x04d8),  // Microchip
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_ProductID),                 SDP_DATA_UINT16_3(0x00e0),  //   PIC32 Starter kit
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_DID_Version),                   SDP_DATA_UINT16_3(0x0031),  //
#endif
};

const unsigned char bt_sdpMasterRecord4[] = {
  SDP_DATA_ELEMENT16_3(56),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceRecordHandle),           SDP_DATA_UINT32_5(0x10040),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceClassIDList),            SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_AudioSink),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ProtocolDescriptorList),        SDP_DATA_ELEMENT8_2(16),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_L2CAP),
                                                                            SDP_DATA_UINT16_3(L2CAP_PDU_PSM_AVDTP),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_AVDTP),
                                                                            SDP_DATA_UINT16_3(0x0103),          // Version
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_BluetoothProfileDescriptorList),SDP_DATA_ELEMENT8_2(8),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_AdvancedAudioDistribution),
                                                                            SDP_DATA_UINT16_3(0x0103),          // Version
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_SupportedFeatures),             SDP_DATA_UINT16_3(0b0000000000000011),	    // Bit 0 = Headphone, Bit 1 = Speaker, Bit 2 = Recorder, Bit 3 = Amplifier, Bit 4-15 = RFA
};

const unsigned char bt_sdpMasterRecord5[] = {
  SDP_DATA_ELEMENT16_3(59),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceRecordHandle),           SDP_DATA_UINT32_5(0x10050),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceClassIDList),            SDP_DATA_ELEMENT8_2(6),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_A_V_RemoteControl),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_A_V_RemoteControlController),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ProtocolDescriptorList),        SDP_DATA_ELEMENT8_2(16),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_L2CAP),
                                                                            SDP_DATA_UINT16_3(L2CAP_PDU_PSM_AVCTP),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_AVCTP),
                                                                            SDP_DATA_UINT16_3(0x0104),          // Version
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_BluetoothProfileDescriptorList),SDP_DATA_ELEMENT8_2(8),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_A_V_RemoteControl),
                                                                            SDP_DATA_UINT16_3(0x0105),          // Version
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_SupportedFeatures),             SDP_DATA_UINT16_3(0b0000000000000001),	    // Bit 0 = Category1, Bit 1 = Category2, Bit 2 = Category3, Bit 3 = Category4, Bit 4-15 = RFA
};

const unsigned char bt_sdpMasterRecord6[] = {
  SDP_DATA_ELEMENT16_3(56),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceRecordHandle),           SDP_DATA_UINT32_5(0x10060),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ServiceClassIDList),            SDP_DATA_ELEMENT8_2(3),
                                                                        SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_A_V_RemoteControlTarget),
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_ProtocolDescriptorList),        SDP_DATA_ELEMENT8_2(16),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_L2CAP),
                                                                            SDP_DATA_UINT16_3(L2CAP_PDU_PSM_AVCTP),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_PROTOCOL_AVCTP),
                                                                            SDP_DATA_UINT16_3(0x0104),          // Version
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_BluetoothProfileDescriptorList),SDP_DATA_ELEMENT8_2(8),
                                                                        SDP_DATA_ELEMENT8_2(6),
                                                                            SDP_DATA_UUID16_3(SDP_SERVICE_CLASS_A_V_RemoteControl),
                                                                            SDP_DATA_UINT16_3(0x0105),          // Version
    SDP_DATA_UINT16_3(SDP_ATTRIBUTE_SupportedFeatures),             SDP_DATA_UINT16_3(0b0000000000000010),	    // Bit 0 = Category1, Bit 1 = Category2, Bit 2 = Category3, Bit 3 = Category4, Bit 4-15 = RFA
};

struct bt_sdpMasterTable    bt_sdpMasterTable[] = {

#ifdef BT_SDP_SPP_ENABLE
    {(unsigned char *)bt_sdpMasterRecord1, 0x10010, 0},
#endif

#ifdef BT_SDP_GATT_ENABLE
    {(unsigned char *)bt_sdpMasterRecord2, 0x10020, 0},
#endif

#ifdef BT_SDP_DID_ENABLE
    {(unsigned char *)bt_sdpMasterRecord3, 0x10030, 0},
#endif

#ifdef BT_SDP_A2DP_SINK_ENABLE
	{(unsigned char *)bt_sdpMasterRecord4, 0x10040, 0},
#endif

#ifdef BT_SDP_AVRCP_ENABLE
  	{(unsigned char *)bt_sdpMasterRecord5, 0x10050, 0},
  	{(unsigned char *)bt_sdpMasterRecord6, 0x10060, 0},
#endif

};

int bt_sdpRecordNum = sizeof(bt_sdpMasterTable) / sizeof(struct bt_sdpMasterTable);

