//
//  lcd_gui_create_integerfield.c	  Part of GUI support library, Integer number field object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#ifndef LCD_GUI_CREATE_INTEGERFIELD_H_
#define LCD_GUI_CREATE_INTEGERFIELD_H_

#include "lcd_gui_figure.h"				// struct lcd_guiGroup
#include <stddef.h>
#include "lcd_color.h"

//
//	Configuration
//
#define LCD_GUI_INTEGER_FIELD_TENKEY_SIZE_W			150
#define LCD_GUI_INTEGER_FIELD_TENKEY_SIZE_H			150

//
//	Control block
//
struct lcd_guiIntegerField {
	struct lcd_guiGroup grp;			// Essential item
	char				*format;
	int					min;
	int					max;
	int					value;
	void				(*actionProg)(struct lcd_guiIntegerField *s);
	char				buff[16];		// Display buffer
};


//
//	API	- Static memory functions
//
// Initialization parameter macro
#define LCD_GUI_INIT_INTEGER_FIELD(next,prev,x,y,width,height,face,back,format,font,min,max,value,eventProg,figs)	{\
		LCD_GUI_INIT_GROUP(next,prev,x,y,width,height,LCD_COLOR_TO_DARK(back),figs,lcd_guiTouchIntegerField),\
		format,\
		min,\
		max,\
		value,\
		eventProg,\
		"",\
}
struct lcd_guiIntegerFieldSet {
	struct lcd_guiIntegerField	integerField;
	struct lcd_guiParent		p;
	struct lcd_guiRect			r1;
	struct lcd_guiRect			r2;
	struct lcd_guiText			t;
};
#define LCD_GUI_INIT_INTEGER_FIELD_SET(name,next,prev,x,y,width,height,face,back,format,font,min,max,value,eventProg)	{\
		LCD_GUI_INIT_INTEGER_FIELD(next,prev,x,y,width,height,face,back,format,font,min,max,value,eventProg,&(name.p)),\
		LCD_GUI_INIT_PARENT(&(name.r1), NULL, NULL),\
		LCD_GUI_INIT_RECT(&(name.r2), NULL, width-1, 0, 1, height-1, LCD_COLOR_TO_LIGHT(back)),\
		LCD_GUI_INIT_RECT(&(name.t), NULL, 0, height-1, width, 1, LCD_COLOR_TO_LIGHT(back)),\
		LCD_GUI_INIT_TEXT(NULL, NULL, 1, 1, width-2, height-2, face,back,LCD_GUI_TEXT_ALIGN_RIGHT,LCD_GUI_TEXT_ALIGN_CENTER,name.integerField.buff,font),\
};
//	ex:
//		void intFieldSub(struct lcd_guiIntegerField *b) {
//			printf("Integer Update!\n");
//		}
//		struct lcd_guiIntegerFieldSet	fld1 = LCD_GUI_INIT_INTEGER_FIELD_SET(fld1, NULL, NULL, 100, 200, 50, 25, LCD_COLOR_LIME, LCD_COLOR_GRAY, "%d", LCD_FONT_6x8, 0, 1000, 99, intFieldSub);
//		struct lcd_guiRootSet			root = LCD_GUI_INIT_ROOT_SET(root, LCD_COLOR_BLACK, &fld1, NULL);


//
//	API	- Dynamic memory functions
//
//extern struct lcd_guiIntegerField	*lcd_guiAllocIntegerField(struct lcd_guiGroup *parent);
extern struct lcd_guiIntegerField	*lcd_guiInitIntegerField(struct lcd_guiIntegerField *alloc, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, char *format, const struct lcd_font *font, int min, int max, int value, void (*actionProg)(struct lcd_guiIntegerField *seg));
//extern struct lcd_guiIntegerField	*lcd_guiNewIntegerField(struct lcd_guiGroup *parent, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, char *format, const struct lcd_font *font, int min, int max, int value, void (*actionProg)(struct lcd_guiIntegerField *seg));
extern int							lcd_guiSetIntegerFieldValue(struct lcd_guiIntegerField *g, int i);
//extern int						lcd_guiGetIntegerFieldValue(struct lcd_guiIntegerField *g);


//
//	Internal
//
extern void lcd_guiTouchIntegerField(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *seg);
#define lcd_guiAllocIntegerField(b)										(struct lcd_guiIntegerField*)lcd_guiAlloc((struct lcd_guiGroup *)(b), sizeof(struct lcd_guiIntegerField))
#define lcd_guiNewIntegerField(b,x,y,w,h,c1,c2,f,fmt,min,max,v,func)	lcd_guiInitIntegerField(lcd_guiAllocIntegerField(b),x,y,w,h,c1,c2,f,fmt,min,max,v,func)
#define lcd_guiGetIntegerFieldValue(b)									((b)->value)

#endif /* LCD_GUI_CREATE_INTEGERFIELD_H_ */
