//
//  bt_avctp_target.h
//
//  Bluetooth Protocol Stack - AVDTP Target side server
//  Copyright (C) 2018 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          Adopted Specifications
//          Protocols
//              AVCTP A/V Control Transport 1.4
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2018.03.07 v0.0  First cording
//

#ifndef BT_AVCTP_TARGET_H_
#define BT_AVCTP_TARGET_H_

#include <string.h>
#include "bt_l2cap_cb_channel.h"        // Channel manage table
#include "bt_spec_avctp.h"          	//

//
//  API
//
// Service task
extern size_t   bt_avctpTarget(
        struct bt_l2capChannel *ch,     // Control block
        unsigned char          *inBuff,
        size_t                  inLen,
        unsigned char          *outBuff,
        size_t                  outSize);

// AVCTP Upper Interface (Call back)
extern void bt_avct_connect(struct bt_l2capChannel *ch);
extern void bt_avct_disconnect(struct bt_l2capChannel *ch);
extern int  bt_avct_messageRec(struct bt_l2capChannel *ch,
                              int           *pid,         // (I/O) Protocol ID
                              int           *transaction, // (I/O) Transaction identifier 0..15
                              int           *type,        // (I/O) Message Type Command=1 / Response=2
                              unsigned char *data,        // (I/O) Received and Sending data
                              size_t        *length);     // (I/O) Data length
                                                          // Return code

#endif /* BT_AVCTP_TARGET_H_ */
