//
//  bt_spec_avctp.h
//
//  Bluetooth Protocol Stack - AVCTP(Audio/Video Control Transport Protocol) Specification definition
//  Copyright (C) 2018 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          Adopted Specifications
//          Protocols
//              AVCTP A/V Control Transport 1.4
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2018.02.07 v0.0  First cording
//

#ifndef BT_SPEC_AVCTP_H_
#define BT_SPEC_AVCTP_H_

#include <stdint.h>

struct bt_avctp_PDU_Format {
	uint8_t header;         // TransactionLabel, PacketType, C/R, IPID
	union {
		struct {
			uint8_t ProfileIdentifier[2];
			uint8_t message[0];
		}   singlePacket;
		struct {
			uint8_t NoP;        // Number of AVCTP Packets
			uint8_t ProfileIdentifier[2];
			uint8_t message[0];
		}   startPacket;
		struct {
			uint8_t message[0];
		}   continuePacket;
		struct {
			uint8_t message[0];
		}   endPacket;
	} body;
} __attribute__ ((packed)) ;

#define AVCTP_HEADER_TransactionLabel_Mask      0b11110000
#define AVCTP_HEADER_TransactionLabel_Shift     4
#define AVCTP_HEADER_PacketType_Mask            0b00001100
#define AVCTP_HEADER_PacketType_SinglePacket    0b00000000
#define AVCTP_HEADER_PacketType_StartPacket     0b00000100
#define AVCTP_HEADER_PacketType_ContinuePacket  0b00001000
#define AVCTP_HEADER_PacketType_EndPacket       0b00001100
#define AVCTP_HEADER_CR_Mask                    0b00000010
#define AVCTP_HEADER_CR_Command                 0b00000000
#define AVCTP_HEADER_CR_Response                0b00000010
#define AVCTP_HEADER_IPID_Mask                  0b00000001
#define AVCTP_HEADER_IPID_Normal                0b00000000
#define AVCTP_HEADER_IPID_Invalid               0b00000001

// Byte order
#define AVCTP_UINT16(a)       (uint16_t)(((a)[0] << 8) | (a)[1])
#define AVCTP_STORE16(d,s)    ((d)[0] = (uint8_t)((s) >> 8), (d)[1] = (uint8_t)(s))

#endif // BT_SPEC_AVCTP_H_
