//
//  lcd_gui_create_textfield.c	  Part of GUI support library, Text string field object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#include <stddef.h>						// NULL,...
#include <string.h>						// strcpy(),...
#include <ctype.h>						// toupper(),...
#include "lcd_gui_create_textfield.h"	// My
#include "lcd_gui_manage.h"				// lcd_guiGetParent()...
#include "lcd_gui_create.h"				// lcd_guiInitGroup()...
#include "lcd_gui_create.h"				//
#include "lcd_gui_create_keypad.h"		//
#include "lcd_gui_create_button.h"		//
#include "lcd_color.h"					// LCD_COLOR*

//
//	Text field
//
void lcd_guiTouchTextPad(struct lcd_guiButton *g){
	struct lcd_guiKeyPad		*keyPad;
	struct lcd_guiButton		*button;
	char						*target;
	size_t						targetLen;
	char						*caption;
	size_t						captionLen;
	struct lcd_guiTextField		*field;

	button     = (struct lcd_guiButton *)g;
	keyPad     = (struct lcd_guiKeyPad *)lcd_guiGetParent(g);
	field      = (struct lcd_guiTextField *)keyPad->targetField;
	target     = field->str;
	caption    = button->capSeg->str;
	targetLen  = strlen(target);
	captionLen = strlen(caption);

	if (!strcmp(caption, "Delete")) {
		if (targetLen > 0) {
			*(target + targetLen - 1) = '\0';
		}
	} else if (!strcmp(caption, "Enter")) {
		struct lcd_guiGroup	*t;
		struct lcd_guiRoot	*root;

		for(t = (struct lcd_guiGroup *)keyPad; t != NULL; t = lcd_guiGetParent(t)) {
			root = (struct lcd_guiRoot *)t;		// Search the root
		}
		lcd_guiDelete(root->popup);
		root->popup = NULL;

		if (field->actionProg) {
			field->actionProg(field);
		}
	} else if (!strcmp(caption, "Shift")) {
		keyPad->shift = button->attr.state;
	} else {
		if ((targetLen + captionLen) < field->len) {
			if (keyPad->shift) {
				for(target += targetLen; captionLen > 0; --captionLen) {
					*(target++) = toupper((int)*(caption++));
				}
			} else {
				for(target += targetLen; captionLen > 0; --captionLen) {
					*(target++) = tolower((int)*(caption++));
				}
			}
			*target = '\0';
		}
	}
	lcd_guiSetDirtys(field);
	return;
}

void lcd_guiTouchTextField(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *seg){
	struct lcd_guiTextField	*field;
	struct lcd_guiGroup		*t;
	struct lcd_guiRoot		*root;
	struct lcd_guiArea		a;

	field = (struct lcd_guiTextField *)seg;
	switch(event){
	case LCD_GUI_EVENT_TOUCH:
		break;
	case LCD_GUI_EVENT_RELEASE:
		a.x      = 0;
		a.y      = field->grp.area.height;
		a.width  = LCD_GUI_TEXTFIELD_KEYPAD_SIZE_W;
		a.height = LCD_GUI_TEXTFIELD_KEYPAD_SIZE_H;
		for(t = seg; t != NULL; t = lcd_guiGetParent(t)) {	// Search the root
			a.x += t->area.x;		// Calculate the field coordinate on root window
			a.y += t->area.y;
			root = (struct lcd_guiRoot *)t;
		}
		a.x = (root->grp.area.width - LCD_GUI_TEXTFIELD_KEYPAD_SIZE_W) / 2;
		if ((a.y + LCD_GUI_TEXTFIELD_KEYPAD_SIZE_H) >= root->grp.area.height) {
			a.y = a.y - LCD_GUI_TEXTFIELD_KEYPAD_SIZE_H - field->grp.area.height;
		}
		if (root->popup != NULL) {
			lcd_guiDelete(root->popup);
		}
		root->popup = (struct lcd_gui *)lcd_guiNewKeyPad(
				root, a.x, a.y, a.width, a.height,
				LCD_GUI_KEYPAD_TYPE_ASCII,
				lcd_guiTouchTextPad,
				field);
		break;
	default:
		break;
	}

	return;
}

struct lcd_guiTextField *lcd_guiInitTextField(
		struct lcd_guiTextField	*alloc,
		short			x,
		short			y,
		short			width,
		short			height,
		unsigned short	faceColor,
		unsigned short	backColor,
		int				horizontalAlign,
		int				verticalAlign,
		char			*str,
		size_t			len,
		const struct lcd_font *font,
		void			(*actionProg)(struct lcd_guiTextField *seg))
{
	unsigned short		darkColor;
	unsigned short		brightColor;

	darkColor   = lcd_colorToDark(backColor);
	brightColor = lcd_colorToLight(backColor);
	lcd_guiInitGroup(&(alloc->grp), x, y, width, height, darkColor, NULL, lcd_guiTouchTextField);
	lcd_guiNewText((struct lcd_guiGroup*)alloc, 1, 1, width-2, height-2, faceColor, backColor, horizontalAlign, verticalAlign, str, font);
	lcd_guiNewRect((struct lcd_guiGroup*)alloc, width-1, 0, 1, height-1, brightColor);
	lcd_guiNewRect((struct lcd_guiGroup*)alloc, 0, height-1, width, 1, brightColor);
	alloc->str          = str;
	alloc->len          = len;
	alloc->actionProg   = actionProg;
	return(alloc);
}

