//
//  lcd_gui_create_textfield.h	  Part of GUI support library, Text string field object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#ifndef LCD_GUI_CREATE_TEXTFIELD_H_
#define LCD_GUI_CREATE_TEXTFIELD_H_

#include "lcd_gui_figure.h"
#include <stddef.h>
#include "lcd_color.h"

//
//	Configuration
//
#define LCD_GUI_TEXTFIELD_KEYPAD_SIZE_W			240
#define LCD_GUI_TEXTFIELD_KEYPAD_SIZE_H			100

//
// Control block
//
struct lcd_guiTextField {
	struct lcd_guiGroup grp;			// Essential item
	char				*str;
	size_t				len;
	void				(*actionProg)(struct lcd_guiTextField *s);
};

//
//	API	- Static memory functions
//
// Initialization parameter macro
#define LCD_GUI_INIT_TEXT_FIELD(next,prev,x,y,width,height,face,back,halign,valign,str,len,font,eventProg,figs)	{\
		LCD_GUI_INIT_GROUP(next,prev,x,y,width,height,LCD_COLOR_TO_DARK(back),figs,lcd_guiTouchTextField),\
		str,\
		len,\
		eventProg,\
}
struct lcd_guiTextFieldSet {
	struct lcd_guiTextField	textField;
	struct lcd_guiParent	p;
	struct lcd_guiRect		r1;
	struct lcd_guiRect		r2;
	struct lcd_guiText		t;
};
#define LCD_GUI_INIT_TEXT_FIELD_SET(name,next,prev,x,y,width,height,face,back,halign,valign,str,len,font,eventProg)	{\
		LCD_GUI_INIT_TEXT_FIELD(next,prev,x,y,width,height,face,back,halign,valign,str,len,font,eventProg,&(name.p)),\
		LCD_GUI_INIT_PARENT(&(name.r1), NULL, NULL),\
		LCD_GUI_INIT_RECT(&(name.r2), NULL, width-1, 0, 1, height-1, LCD_COLOR_TO_LIGHT(back)),\
		LCD_GUI_INIT_RECT(&(name.t), NULL, 0, height-1, width, 1, LCD_COLOR_TO_LIGHT(back)),\
		LCD_GUI_INIT_TEXT(NULL, NULL, 1, 1, width-2, height-2, face,back,halign,valign,str,font),\
};
//	ex:
//		void textFieldSub(struct lcd_guiTextField *b) {
//			printf("Text Update!\n");
//		}
//		char						buf[8] = "Test";
//		struct lcd_guiTextFieldSet	fld1 = LCD_GUI_INIT_TEXT_FIELD_SET(fld1, NULL, NULL, 100, 200, 50, 25, LCD_COLOR_LIME, LCD_COLOR_GRAY, LCD_GUI_TEXT_ALIGN_CENTER, LCD_GUI_TEXT_ALIGN_CENTER, buf, sizeof(buf), LCD_FONT_6x8, textFieldSub);
//		struct lcd_guiRootSet		root = LCD_GUI_INIT_ROOT_SET(root, LCD_COLOR_BLACK, &fld1, NULL);


//
//	API	- Dynamic memory functions
//
//extern struct lcd_guiTextField	*lcd_guiAllocTextField(struct lcd_guiGroup *parent);
extern struct lcd_guiTextField		*lcd_guiInitTextField(struct lcd_guiTextField *alloc, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, int hAlign, int vAlign, char *str, size_t len, const struct lcd_font *font, void (*actionProg)(struct lcd_guiTextField *seg));
//extern struct lcd_guiTextField	*lcd_guiNewTextField(struct lcd_guiGroup *parent, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, int hAlign, int vAlign, char *str, size_t len, const struct lcd_font *font, void (*actionProg)(struct lcd_guiTextField *seg));


//
//	Internal
//
extern void lcd_guiTouchTextField(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *seg);
#define lcd_guiAllocTextField(b)									(struct lcd_guiTextField*)lcd_guiAlloc((struct lcd_guiGroup *)(b), sizeof(struct lcd_guiTextField))
#define lcd_guiNewTextField(b,x,y,w,h,c1,c2,ha,va,s,l,f,func)		lcd_guiInitTextField(lcd_guiAllocTextField(b),x,y,w,h,c1,c2,ha,va,s,l,f,func)


#endif /* LCD_GUI_CREATE_TEXTFIELD_H_ */
