//
//  lcd_gui_display.c	  Part of GUI support library, Figure data block
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#ifndef LCD_GUI_FIGURE_H_
#define LCD_GUI_FIGURE_H_

#include "lcd_font.h"

//
//	Basic type
//
struct lcd_guiCoordinate {			// Screen point
	short			x;
	short			y;
};
struct lcd_guiArea {				// Screen rect
	short			x;
	short			y;
	short			width;
	short			height;
};
struct lcd_guiColors {				//
	unsigned short	face;
	unsigned short	back;
};

//
//	Control block
//

//
//	Common header
//
struct lcd_gui {
	struct lcd_gui		*next;			// Horizontal chain link
	struct lcd_gui		*prev;			// Backward relation
	struct lcd_guiFigFlag {
		unsigned int		dirty:	1;	// 1:Need a redisplay
		unsigned int		hidden:	1;	// 1:Disable entry
		unsigned int		malloc: 1;	// 0:fig="Static memory area" 1:fig="Heap memory area"
		unsigned int		init: 	1;	// 1:Request for initial display (option)
	}					flags;
	int					(*dispProg)(struct lcd_gui *seg, struct lcd_guiCoordinate *base);	// = fig types

	// Body ...
};
// fig types
extern int	lcd_guiDisplayRect		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayLine		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayPoly		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayArc		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayStr		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayImage		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayText		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayGage		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplay7seg		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayBarChart	(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplay			(struct lcd_gui *top, struct lcd_guiCoordinate *cardinalPoint);
extern int	lcd_guiDisplayGroup		(struct lcd_gui *seg, struct lcd_guiCoordinate *cardinalPoint);

//
//	Filler box
//
struct lcd_guiRect {
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayRect
	struct lcd_guiArea			area;
	unsigned short				color;
};

//
//	Single line
//
struct lcd_guiLine {
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayLine
	struct lcd_guiCoordinate	startPoint;
	struct lcd_guiCoordinate	endPoint;
	short 						lineWidth;
	unsigned short				color;
};

//
//	Multi line
//
struct lcd_guiPoly {
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayPoly
	struct lcd_guiCoordinate	*point;
	int 						n;
	int 						m;
	short 						lineWidth;
	unsigned short				color;
};

//
//	Arc and circle
//
struct lcd_guiArc {
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayArc
	struct lcd_guiCoordinate	center;
	short						r;
	float						startRad;
	float						endRad;
	short 						lineWidth;
	unsigned short				color;
};

//
//	Single line simple character string figure
//
struct lcd_guiStr {				//
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayStr
	struct lcd_guiCoordinate	point;
	struct lcd_guiColors		color;
	char						*str;
};

//
//	Bit image
//
struct lcd_guiImage {
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayImage
	struct lcd_guiArea			area;
	unsigned short				*image;
};

//
//	Box text string figure
//
struct lcd_guiText {			//
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayText
	struct lcd_guiArea			area;
	struct lcd_guiColors		color;
	struct lcd_segmenTextAttr {
		unsigned int				horizontalAlign: 2;
		unsigned int				varticalAlign: 2;
	}							attr;
	char						*str;
	const struct lcd_font		*font;
};
#define LCD_GUI_TEXT_ALIGN_LEFT			0
#define LCD_GUI_TEXT_ALIGN_UP			0
#define LCD_GUI_TEXT_ALIGN_CENTER		1
#define LCD_GUI_TEXT_ALIGN_RIGHT		2
#define LCD_GUI_TEXT_ALIGN_DOWN			2

//
//	Simple bar graph
//
struct lcd_guiGage {
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayGage
	struct lcd_guiArea			area;
	struct lcd_guiColors		color;
	struct lcd_segmenGageAttr {
		unsigned int				vartical:		1;
	}							attr;
	float						value;			// 0.0 - 1.0
	struct {
		int							beforePos;
	}							internal;
};

//
//	Stacked bar graph
//
struct lcd_guiBarChart {
	// Stacked bar graph
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplayBarChart
	struct lcd_guiArea			area;
	unsigned short				backColor;
	struct lcd_segmenGageAttr 	attr;
	int							number;
	float						*value;			// 0.0 - 1.0
	unsigned short				*color;
};

//
//	7 segment LED emulation
//
struct lcd_gui7seg {			// 7segment LED
	struct lcd_gui				seg;			// dispProg=lcd_guiDisplay7seg
	struct lcd_guiArea			area;
	struct lcd_guiColors		color;
	short						lineWidth;
	int							column;
	unsigned char				*pattern;
};

//
//	Group segment
//
enum lcd_guiEvent {
	LCD_GUI_EVENT_IDLE = 0,
	LCD_GUI_EVENT_TOUCH,
	LCD_GUI_EVENT_SLIDE,
	LCD_GUI_EVENT_RELEASE,
};
struct lcd_guiGroup {					// Group > Figure, inclusive
	struct lcd_gui		seg;			// dispProg=lcd_guiDisplayGroup
	struct lcd_guiArea	area;			//
	unsigned short		backColor;		//
	struct lcd_gui		*top;			// Figures
	void				(*eventProg)(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *group);
};
struct lcd_guiParent {
	struct lcd_gui		seg;			//
	struct lcd_guiGroup	*parent;		//
};

//
//	Root group
//
struct lcd_guiRoot {
	struct lcd_guiGroup		grp;
	struct lcd_gui			*popup;		//
};

#endif /* LCD_GUI_FIGURE_H_ */
