//
//  z180sn009_1.c	Transport layer (Physical device interface)
//  Graphic LCD module "Z180SN009" I/O library
//  Copyright(C)2019 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//	Description
//		I/O control for Graphic LCD module.
//		LCD module: Z180SN009. (Controller chip is Sitronix Technology ST7735S)
//		Interface:
//				Software control:
//					4-lines: LCD_PIN_CS, LCD_PIN_DC, LCD_PIN_SCLK, LCD_PIN_SDATA
//				Hardware control:
//					4-lines: LCD_PIN_CS, LCD_PIN_DC, LCD_PORT_SPI
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2019.01.24 v0.0  First cording
//

#include "z180sn009_1.h"

//
//	Blocked wait
//
void lcd_portWait(int ms) {
	uint32_t	w;
	w = HAL_GetTick() + ms;
	while(w > HAL_GetTick());
	return;
}

//---------------------------------------------------------------------
//		Serial Peripheral Interface
//---------------------------------------------------------------------
#if defined(LCD_PORT_MODE_SPI) && (LCD_PORT_MODE_SPI == 0)

//
//	Start
//
void lcd_portStart(void) {
	LCD_PIN_CS_INIT();
	LCD_PIN_SCK_INIT();
	LCD_PIN_SDATA_INIT();
	LCD_PIN_DC_INIT();
	return;
}

//
//	Stop
//
void lcd_portStop(void) {
	LCD_PIN_DC_TERM();
	LCD_PIN_SDATA_TERM();
	LCD_PIN_SCK_TERM();
	LCD_PIN_CS_TERM();
	return;
}

void lcd_portWrite8(unsigned char dc, unsigned char data) {
	unsigned char	i;

//	LCD_PIN_CS_ON();
#ifdef LCD_PIN_DC_ON					// 8bits, 4-lines Serial Peripheral Interface
	if (dc) {
		LCD_PIN_DC_ON();
	} else {
		LCD_PIN_DC_OFF();
	}
#else									// 9bits, 3-lines Serial Peripheral Interface
	if (dc) {
		LCD_PIN_SDATA_ON();
	} else {
		LCD_PIN_SDATA_OFF();
	}
	LCD_PIN_SCK_ON();
	LCD_PIN_SCK_OFF();
#endif
	for(i = 0; i < 8; i++) {
		if (data & 0x80) {
			LCD_PIN_SDATA_ON();
		} else {
			LCD_PIN_SDATA_OFF();
		}
		LCD_PIN_SCK_ON();
		LCD_PIN_SCK_OFF();
		data <<= 1;
	}
//	LCD_PIN_CS_OFF();
	return;
}

void lcd_portWriteCmd(unsigned cmd) {
	LCD_PIN_CS_ON();
	lcd_portWrite8(0, cmd);
//	LCD_PIN_CS_OFF();
	return;
}

void lcd_portWriteCmdPrm(unsigned cmd, unsigned char data) {
	LCD_PIN_CS_ON();
	lcd_portWrite8(0, cmd);
	lcd_portWrite8(1, data);
//	LCD_PIN_CS_OFF();
	return;
}

void lcd_portWriteData(unsigned short data) {
	lcd_portWrite8(1, data >> 8);
	lcd_portWrite8(1, data & 0xff);
	return;
}

void lcd_portWritePeriod(void) {
	LCD_PIN_CS_OFF();
	return;
}

#else
#error "Not support SPI mode"
#endif

