//
//  z180sn009_1.h	Transport layer (Physical device interface)
//  Graphic LCD module "Z180SN009" I/O library
//  Copyright(C)2019 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2019.01.24 v0.0  First cording
//

#ifndef Z180SN009_1_H_
#define Z180SN009_1_H_

//---------------------------------------------------------------------
//
// Hardware configuration & Option
//
//---------------------------------------------------------------------

// Interface mode

//#define LCD_PORT_MODE_6800			// MPU Parallel 6800-series Interface <NOT SUPPORTED>
//#define LCD_PORT_MODE_8080			// MPU Parallel 8080-series Interface <NOT SUPPORTED>
  #define LCD_PORT_MODE_SPI		0		// MPU Serial Peripheral Interface 0:soft 1:hard

// Port defines
#ifdef USE_HAL_DRIVER				// STM32Cube HAL Drivers
#include <stm32f4xx_hal.h>

#if defined(LCD_PORT_MODE_SPI) && (LCD_PORT_MODE_SPI == 0)
#define LCD_PIN_CS_ON()			HAL_GPIO_WritePin(GPIOC, GPIO_PIN_9, GPIO_PIN_RESET)	// Negative
#define LCD_PIN_CS_OFF()		HAL_GPIO_WritePin(GPIOC, GPIO_PIN_9, GPIO_PIN_SET)
#define LCD_PIN_CS_INIT()				// STM32CubeMX
#define LCD_PIN_CS_TERM()				// STM32CubeMX
#define LCD_PIN_SCK_ON()		HAL_GPIO_WritePin(GPIOC, GPIO_PIN_10, GPIO_PIN_SET)
#define LCD_PIN_SCK_OFF()		HAL_GPIO_WritePin(GPIOC, GPIO_PIN_10, GPIO_PIN_RESET)
#define LCD_PIN_SCK_INIT()				// STM32CubeMX
#define LCD_PIN_SCK_TERM()				// STM32CubeMX
#define LCD_PIN_SDATA_ON()		HAL_GPIO_WritePin(GPIOC, GPIO_PIN_12, GPIO_PIN_SET)
#define LCD_PIN_SDATA_OFF()		HAL_GPIO_WritePin(GPIOC, GPIO_PIN_12, GPIO_PIN_RESET)
#define LCD_PIN_SDATA_INIT()			// STM32CubeMX
#define LCD_PIN_SDATA_TERM()			// STM32CubeMX
#define LCD_PIN_DC_ON()			HAL_GPIO_WritePin(GPIOC, GPIO_PIN_11, GPIO_PIN_SET)		// 4-lines Serial Peripheral Interface
#define LCD_PIN_DC_OFF()		HAL_GPIO_WritePin(GPIOC, GPIO_PIN_11, GPIO_PIN_RESET)
#define LCD_PIN_DC_INIT()				// STM32CubeMX
#define LCD_PIN_DC_TERM()				// STM32CubeMX

#else
#error "Not supported SPI mode"
#endif

#else
#error "Not supported device"
#endif

//---------------------------------------------------------------------
//
// Prototype
//
//---------------------------------------------------------------------
extern void		lcd_portStart(void);
extern void		lcd_portStop(void);
extern void		lcd_portWait(int ms);
extern void 	lcd_portWriteCmd(unsigned cmd);
extern void 	lcd_portWriteCmdPrm(unsigned cmd, unsigned char data);
extern void 	lcd_portWriteData(unsigned short data);
extern void 	lcd_portWritePeriod(void);

#endif /* Z180SN009_1_H_ */
