//
//  bt_att_data.c
//
//  Bluetooth Protocol Stack - Attribute Database
//   <Audio amp>
//

#include "bt_spec_gatt.h"
#include "bt_spec_att.h"
#include "bt_att_db.h"
#include "bt_config.h"

// Alias
#define UINT16(a)  ATT_UINT16_DATA(a)       // Alias (Short name)
#define UINT32(a)  ATT_UINT32_DATA(a)       // Alias
#define UU16(a)    ATT_UUID16TO128_DATA(a)  // Alias
#define UU128(a)   ATT_UUID128_DATA(a)      // Alias

//
//  ATT Database
//
struct bt_attDb bt_attDb = {
    72,
    {// Handle  Type                                                                                  Len  Values                                                                                                                       Property
        {0x0001,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_Services_Generic_Access_Profile)},                                                                              ATT_DB_PROPERTIES_READ},
        {0x0002,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x0003), UINT16(GATT_Characteristic_Types_Device_Name)},                        ATT_DB_PROPERTIES_READ},
        {0x0003,        {UU16(GATT_Characteristic_Types_Device_Name)},                                20,  {'A','u','d','i','o',' ','a','m','p','l','i','f','i','e','r',' ','m','i','n','i'},                                           ATT_DB_PROPERTIES_READ},
        {0x0004,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x0005), UINT16(GATT_Characteristic_Types_Appearance)},                         ATT_DB_PROPERTIES_READ},
        {0x0005,        {UU16(GATT_Characteristic_Types_Appearance)},                                  2,  {UINT16(GATT_Characteristic_Appearance_Category_Generic_Media_Player)},                                                      ATT_DB_PROPERTIES_READ},

        {0x0011,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_Services_Generic_Attribute_Profile)},                                                                           ATT_DB_PROPERTIES_READ},
        {0x0012,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read | GATT_Characteristic_Properties_Write_Without_Response | GATT_Characteristic_Properties_Indicate,
                                                                                                            UINT16(0x0013), UINT16(GATT_Characteristic_Types_Service_Changed)},                                                         ATT_DB_PROPERTIES_READ},
        {0x0013,        {UU16(GATT_Characteristic_Types_Service_Changed)},                             4,  {UINT16(0x0001), UINT16(0xffff)},                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
        {0x0014,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
        {0x0015,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},

//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x1000,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_services_automation_io)},                                                                                       ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x1001,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read|GATT_Characteristic_Properties_Write|GATT_Characteristic_Properties_Notify, UINT16(0x1002), UINT16(GATT_characteristic_analog)},ATT_DB_PROPERTIES_READ},
        {0x1002,        {UU16(GATT_characteristic_analog)},                                            2,  {UINT16(10)},                                                                                                                ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
        {0x1003,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
        {0x1004,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
        {0x1005,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      11,  {'M','a','i','n',' ','V','o','l','u','m','e'},                                                                               ATT_DB_PROPERTIES_READ},
        {0x1006,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint16, 0, UINT16(GATT_Characteristic_Unit_percentage),
                                                                                                            GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x1011,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read|GATT_Characteristic_Properties_Write|GATT_Characteristic_Properties_Notify, UINT16(0x1012), UINT16(GATT_characteristic_analog)},ATT_DB_PROPERTIES_READ},
        {0x1012,        {UU16(GATT_characteristic_analog)},                                            2,  {UINT16(100)},                                                                                                               ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
        {0x1013,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
        {0x1014,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
        {0x1015,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      10,  {'A','c','h',' ','V','o','l','u','m','e'},                                                                                   ATT_DB_PROPERTIES_READ},
        {0x1016,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint16, 0, UINT16(GATT_Characteristic_Unit_percentage),
                                                                                                            GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		{0x1021,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read|GATT_Characteristic_Properties_Write|GATT_Characteristic_Properties_Notify, UINT16(0x1022), UINT16(GATT_characteristic_analog)},ATT_DB_PROPERTIES_READ},
		{0x1022,        {UU16(GATT_characteristic_analog)},                                            2,  {UINT16(0)},                                                                                                                 ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1023,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
		{0x1024,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1025,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      11,  {'A','c','h',' ','B','a','l','a','n','c','e'},                                                                               ATT_DB_PROPERTIES_READ},
		{0x1026,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint16, 0, UINT16(GATT_Characteristic_Unit_percentage),
																											GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		{0x1031,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read|GATT_Characteristic_Properties_Write|GATT_Characteristic_Properties_Notify, UINT16(0x1032), UINT16(GATT_characteristic_analog)},ATT_DB_PROPERTIES_READ},
		{0x1032,        {UU16(GATT_characteristic_analog)},                                            2,  {UINT16(100)},                                                                                                               ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1033,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
		{0x1034,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1035,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      10,  {'B','c','h',' ','V','o','l','u','m','e'},                                                                                   ATT_DB_PROPERTIES_READ},
		{0x1036,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint16, 0, UINT16(GATT_Characteristic_Unit_percentage),
																											GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		{0x1041,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read|GATT_Characteristic_Properties_Write|GATT_Characteristic_Properties_Notify, UINT16(0x1042), UINT16(GATT_characteristic_analog)},ATT_DB_PROPERTIES_READ},
		{0x1042,        {UU16(GATT_characteristic_analog)},                                            2,  {UINT16(0)},                                                                                                                 ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1043,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
		{0x1044,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1045,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      11,  {'B','c','h',' ','B','a','l','a','n','c','e'},                                                                               ATT_DB_PROPERTIES_READ},
		{0x1046,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint16, 0, UINT16(GATT_Characteristic_Unit_percentage),
																											GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		{0x1051,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read|GATT_Characteristic_Properties_Write|GATT_Characteristic_Properties_Notify, UINT16(0x1052), UINT16(GATT_characteristic_analog)},ATT_DB_PROPERTIES_READ},
		{0x1052,        {UU16(GATT_characteristic_analog)},                                            2,  {UINT16(100)},                                                                                                               ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1053,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
		{0x1054,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1055,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      16,  {'B','l','u','e','t','o','o','t','h',' ','V','o','l','u','m','e'},                                                           ATT_DB_PROPERTIES_READ},
		{0x1056,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint16, 0, UINT16(GATT_Characteristic_Unit_percentage),
																											GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		{0x1061,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read|GATT_Characteristic_Properties_Write|GATT_Characteristic_Properties_Notify, UINT16(0x1062), UINT16(GATT_characteristic_analog)},ATT_DB_PROPERTIES_READ},
		{0x1062,        {UU16(GATT_characteristic_analog)},                                            2,  {UINT16(0)},                                                                                                                 ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
		{0x1063,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
		{0x1064,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ},
		{0x1065,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      17,  {'B','l','u','e','t','o','o','t','h',' ','B','a','l','a','n','c','e'},                                                       ATT_DB_PROPERTIES_READ},
		{0x1066,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint16, 0, UINT16(GATT_Characteristic_Unit_percentage),
																											GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},

//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2000,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_services_device_information)},                                                                                  ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2001,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2002), UINT16(GATT_characteristic_manufacturer_name_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2002,        {UU16(GATT_characteristic_manufacturer_name_string)},                         16,  {'T','o','y','o','h','i','k','o',' ','T','o','g','a','s','h','i'},                                                           ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2011,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2012), UINT16(GATT_characteristic_model_number_string)},                      ATT_DB_PROPERTIES_READ},
        {0x2012,        {UU16(GATT_characteristic_model_number_string)},                               6,  {'B','T','S','P','0','2'},                                                                                                   ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2021,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2022), UINT16(GATT_characteristic_serial_number_string)},                     ATT_DB_PROPERTIES_READ},
        {0x2022,        {UU16(GATT_characteristic_serial_number_string)},                              5,  {'#','0','0','0','1'},                                                                                                       ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2031,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2032), UINT16(GATT_characteristic_hardware_revision_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2032,        {UU16(GATT_characteristic_hardware_revision_string)},                          3,  {'0','.','2'},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2041,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2042), UINT16(GATT_characteristic_firmware_revision_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2042,        {UU16(GATT_characteristic_firmware_revision_string)},                          3,  {'0','.','2'},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2051,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2052), UINT16(GATT_characteristic_software_revision_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2052,        {UU16(GATT_characteristic_software_revision_string)},                          3,  {'0','.','2'},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2061,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2062), UINT16(GATT_characteristic_system_id)},                                ATT_DB_PROPERTIES_READ},
        {0x2062,        {UU16(GATT_characteristic_system_id)},                                         2,  {UINT16(123)},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2071,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2072), UINT16(GATT_characteristic_ieee_11073_20601_regulatory_certification_data_list)},ATT_DB_PROPERTIES_READ},
        {0x2072,        {UU16(GATT_characteristic_ieee_11073_20601_regulatory_certification_data_list)},1,  {0x00},                                                                                                                     ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2081,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2082), UINT16(GATT_characteristic_pnp_id)},                                   ATT_DB_PROPERTIES_READ},
        {0x2082,        {UU16(GATT_characteristic_pnp_id)},                                            7,  {GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers,UINT16(999),UINT16(1),UINT16(0x0010)},                         ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    }
};
