//
//  bt_config.Speaker.h
//
//  Bluetooth Protocol Stack - Configuration
//   <Sample data: Speaker>
//

#ifndef BT_CONFIG_H_
#define	BT_CONFIG_H_
#include "bt_spec_gatt.h"   // GAP
#include "bt_spec_cod.h"    // Device class

//
//  BR/EDR Inquiry scan
//
  #define BT_DEVICE_CLASS           (COS_MAJOR_Rendering | COS_MAJOR_Audio | COD_Audio_Video_Loudspeaker)
//#define BT_DEVICE_CLASS           (COS_MAJOR_Rendering | COS_MAJOR_Audio | COD_Audio_Video_Wearable_Headset_Device)
  #define BT_INIT_DETECT_ENABLE     // BR/EDR Inquiry scan enable
  #define BT_LOCAL_NAME             7,'B','T','S','P','0','1','\0'
//#define BT_SDP_SPP_ENABLE         // Serial port
//#define BT_SDP_GATT_ENABLE        // ATT on BR/EDR
  #define BT_SDP_DID_ENABLE         // PnP Information
  #define BT_SDP_A2DP_SINK_ENABLE   // AVDTP Audio Sink

//
//  LE advertise
//
//#define BT_INIT_LE_DETECT_ENABLE  // LE advertise enable
  #define BT_LE_SCAN_RESPONSE       32,31,12,GAP_AD_Type_Shortened_local_name,'B','l','u','e','t','o','o','t','h','4','P',\
	                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  #define BT_LE_ADVERTISING         32,11,2,GAP_AD_Type_Flags,(GAP_AD_Flags_Simultaneous_LE_BR_EDR_Host | GAP_AD_Flags_Simultaneous_LE_BR_EDR_Controller | GAP_AD_Flags_LE_General_Discoverable_Mode),\
                                          3,GAP_AD_Type_16bit_Service_UUIDs_Complete,HCI_UINT16_DATA(GATT_services_heart_rate),\
                                          3,GAP_AD_Type_16bit_Service_UUIDs_Complete,HCI_UINT16_DATA(GATT_services_device_information),\
                                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
//#define BT_LE_ADVERTISING         32,11,2,GAP_AD_Type_Flags,(GAP_AD_Flags_Simultaneous_LE_BR_EDR_Host | GAP_AD_Flags_Simultaneous_LE_BR_EDR_Controller | GAP_AD_Flags_LE_General_Discoverable_Mode),
//                                        3,GAP_AD_Type_16bit_Service_UUIDs_Complete,HCI_UINT16_DATA(GATT_services_health_thermometer),
//                                        3,GAP_AD_Type_16bit_Service_UUIDs_Complete,HCI_UINT16_DATA(GATT_services_device_information),
//                                          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
//#define BT_ATT_SERVICE_UUID128    0x83B53D6A,0xF330,0x4C9A,0x888C,0xD69BF306FF00  // Private
//#define BT_LE_ADVERTISING         32,21,2,GAP_AD_Type_Flags,(GAP_AD_Flags_Simultaneous_LE_BR_EDR_Host | GAP_AD_Flags_Simultaneous_LE_BR_EDR_Controller | GAP_AD_Flags_LE_General_Discoverable_Mode),
//                                       17,GAP_AD_Type_128bit_Service_UUIDs_Complete,UU128(BT_ATT_SERVICE_UUID128),
//                                          0,0,0,0,0,0,0,0,0,0,0

//
// Policy of security
//
  #define BT_RFCOMM_PERMISSION      BT_L2CAP_SERVICE_PERMISSIONS_Allow
//#define BT_RFCOMM_PERMISSION      BT_L2CAP_SERVICE_PERMISSIONS_Encryption_Required
//#define BT_RFCOMM_PERMISSION      BT_L2CAP_SERVICE_PERMISSIONS_Authentication_Required

  #define BT_AVDTP_PERMISSION       BT_L2CAP_SERVICE_PERMISSIONS_Allow
//#define BT_AVDTP_PERMISSION       BT_L2CAP_SERVICE_PERMISSIONS_Encryption_Required
//#define BT_AVDTP_PERMISSION       BT_L2CAP_SERVICE_PERMISSIONS_Authentication_Required

  #define BT_SDP_PERMISSION         BT_L2CAP_SERVICE_PERMISSIONS_Allow
//#define BT_SDP_PERMISSION         BT_L2CAP_SERVICE_PERMISSIONS_Encryption_Required
//#define BT_SDP_PERMISSION         BT_L2CAP_SERVICE_PERMISSIONS_Authentication_Required

  #define BT_SSP_IO_CAPABIRITY      HCI_Parm_IO_Capability_NoInputNoOutput
//#define BT_SSP_IO_CAPABIRITY      HCI_Parm_IO_Capability_DisplayOnly
//#define BT_SSP_IO_CAPABIRITY      HCI_Parm_IO_Capability_DisplayYesNo
//#define BT_SSP_IO_CAPABIRITY      HCI_Parm_IO_Capability_KeyboardOnly

//#define BT_SSP_AUTHENTICATION     HCI_Parm_Authentication_Requirements_Numeric_Comparison
//#define BT_SSP_AUTHENTICATION     HCI_Parm_Authentication_Requirements_Use_IO_Capabilities
//#define BT_SSP_AUTHENTICATION     HCI_Parm_Authentication_Requirements_Dedicated_Bonding_Numeric_Comparison
  #define BT_SSP_AUTHENTICATION     HCI_Parm_Authentication_Requirements_Dedicated_Bonding_Use_IO_Capabilities
//#define BT_SSP_AUTHENTICATION     HCI_Parm_Authentication_Requirements_General_Bonding_Numeric_Comparison
//#define BT_SSP_AUTHENTICATION     HCI_Parm_Authentication_Requirements_General_Bonding_Use_IO_capabilities

  #define BT_SMP_IO_CAPABIRITY      SMP_IO_Capability_NoInputNoOutput
//#define BT_SMP_IO_CAPABIRITY      SMP_IO_Capability_DisplayOnly
//#define BT_SMP_IO_CAPABIRITY      SMP_IO_Capability_KeyboardOnly
//#define BT_SMP_IO_CAPABIRITY      SMP_IO_Capability_KeyboardDisplay

//#define BT_SMP_AUTHENTICATION     SMP_AuthReq_No_Bonding
//#define BT_SMP_AUTHENTICATION     SMP_AuthReq_Bonding
  #define BT_SMP_AUTHENTICATION     SMP_AuthReq_Bonding | SMP_AuthReq_MITM

  #define BT_SMP_DEFAULT_PASSKEY    123456
  #define BT_SMP_STK_SRAND          0xE0,0x2E,0x70,0xC6,0x4E,0x27,0x88,0x63,0x0E,0x6F,0xAD,0x56,0x21,0xD5,0x83,0x57
  #define BT_SMP_KEY_ER             0xF9,0x2D,0xF2,0x3F,0xDB,0x39,0x43,0xC0,0xA4,0x95,0xB6,0x88,0x8E,0x87,0x7C,0x44
  #define BT_SMP_KEY_IR             0xDD,0xC3,0x21,0x08,0xA3,0x26,0x47,0xD2,0x93,0x8D,0xC9,0x04,0x27,0x79,0x50,0x27

#endif	/* BT_CONFIG_H_ */
