//
//  usbh_wcc_bluetooth.c
//
//  USB Host Protocol Stack - USB Wireless controller class for bluetooth dongle
//  Copyright (C) 2019 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//	Reference:
//		Bluetooth SIG (www.bluetooth.com)
//			BLUETOOTH SPECIFICATION Version 4.0
//				[Vol 4] Host Controller Interface [Transport Layer]
//				Part B: USB Transport Layer
//		STMicroelectronics
//			STM32 USB HOST Library / STM32Cube FW_F4 V1.24.0
//
//	Device:
//		STM32Fxx
//
//	Update history
//	---------- ----- -------------------------------------------
//	2019.04.13 v0.0  First cording
//
#ifndef __USBH_WCC_BLUETOOTH_H
#define __USBH_WCC_BLUETOOTH_H

#include <stddef.h>
#include <time.h>
#include "usbh_core.h"

//
//	USB.org
//
#define USB_WCC_CLASS			0xe0	// Wireless controller class
#define USB_WCC_CLASS_RF		1		// Sub class / RF controller
#define USB_PROTOCOL_BLUETOOTH	1		// Bluetooth Programing Interface
#define USB_PROTOCOL_BT_AMP		4		// Bluetooth AMP Controller

//
//	Class jump table
//
extern USBH_ClassTypeDef  			USBH_wcc_bluetooth;
#define USBH_WCC_BLUETOOTH_CLASS    &USBH_wcc_bluetooth

#endif  /* __USBH_WCC_BLUETOOTH_H */
