//
//  bt.h
//
//  Bluetooth Protocol Stack - Read me file
//  Copyright (C) 2013-2019 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Description
//      This is the protocol stack of bluetooth for small embedded device.
//      Supported function:
//          SDP     Service discovery protocol
//          RFCOMM  Serial communication
//          ATT     Attribute protocol
//          SMP     Security Manager protocol
//          AVDTP   Audio/Video Distribution Transport Protocol
//          A2DP    Advanced Audio Distribution Profile
//      Depend reference:
//          time.h              time()
//          rijndael-api-ref.h  AES cryptographic routines
//
//  Usage:
//      Program flow is an event loop type.
//      Example
//          #include <time.h>
//          #include <string.h>
//          #include "bt.h"               // Bluetooth API
//          main(){
//              time_t tm;
//              char  *msg = "Hello world.\n";
//
//                :
//              tm = 0;
//                :
//              for(;;) {
//                    :
//                  if (BSP_SwitchStateGet(BSP_SWITCH_1) == BSP_SWITCH_STATE_PRESSED) {
//                      bt_rfcommServerDataSendRequest(msg, strlen(msg));
//                  }
//                  if (tm != time(NULL)) {
//                      tm  = time(NULL);
//                      bt_attDbUpdate(0x1012, &tm, sizeof(tm)); // and notify
//                  }
//                    :
//              }
//          }
//
//          void bt_rfcommServerDataRecived(unsigned char *inBuff, size_t inLen){
//              printf("RFCOMM recv: %s\n", inBuff);
//              return;
//          }
//
//          void bt_attDbNotification(unsigned short handle, void *value, size_t valueLen){
//              bt_att_serverNotificationQueueAdd(handle);    // Essential action
//              switch(handle) {
//              case 0x1002:
//                  if (*(unsigned char *)value == 0x00) {
//                      BSP_LEDOff(BSP_LED_1);
//                  } else {
//                      BSP_LEDOn(BSP_LED_1);
//                  }
//                  break;
//              default:
//                  break;
//              }
//              return;
//          }
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 4.0
//
//  Device: STM32F4
//    Case 1
//      IDE     : Eclipse IDE for C/C++ Developers   4.2.1(Juno)  4.4.0(Luna)
//      Compiler: gcc-arm-none-eabi                  4.7          4.8
//      Library : Cortex-M CMSIS driver              V2.10        V2.10
//                STM32F4xx CMSIS                    V1.0.2       V1.0.2
//                STM32F4xx_StdPeriph_Driver         V1.0.2       V1.0.2
//                STM32_USB_Device_Library           V1.1.0       V1.1.0
//                STM32_USB_OTG_Driver               V2.1.0       V2.1.0
//                STM32_USB_HOST_Library             V2.1.0       V2.1.0
//                STM32F4-Discovery_FW               V1.1.0       V1.1.0
//    Case 2
//      IDE     : System Workbench for STM32 - C/C++ Embedded Development Tools for MCU 2.8 / Ac6 Tools
//      Compiler: Include
//      Library : STM32Cube_FW_F4_V1.24.0
//
//  Device: PIC32MX
//      IDE     : MPLAB X IDE        v2.26   v3.20
//      Compiler: Xc32-gcc           v1.33   v1.40
//      Library : Microchip Harmony  v1.01   v1.06.02
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2014.03.05 v0.2  Change the USB process calling
//  2015.02.03 v0.3  Supported the PIC32
//  2015.02.06 v0.3a Supported the Secure Simple Pairing
//  2015.02.06 v0.3a SDP: Securely it tried to do search processing (but not support AttributeIDList condition)
//  2015.02.20 v0.3b The new "bt_att_data.c" is independent of the ATT database user data
//  2015.03.03 v0.3b Concealment of bluetooth task to the user
//  2016.02.12 v0.3c Appended a return code, Supported the XC32 v1.40
//  2016.02.15 v0.3c Disabled the Security Manager, default service
//  2016.02.19 v0.3c+ Change of the PIN response(HCI command/event)
//  2016.02.20 v0.3c+ Bug fix, bt_l2cap??????GetNext()
//  2016.04.21 v0.3d Appended a API for SSP(Secure Simple Pairing)
//  2017.01.03 v0.3e Changed a argument (handle -> cb_channel, BD_ADDR -> cb_link, psm -> cb_service)
//  2017.01.08 v0.3e Appended a authentication function for the classic services(e.g. RFCOMM)
//  2017.01.08 v0.3e Renamed scid,dcid -> peerCid,myCid
//  2017.01.18 v0.3f Appended a authentication function for the SM(Security Manager) and ATT(Attribute server)
//  2017.02.06 v0.3g Supported a 16bit UUID (ATT)
//  2017.02.11 v0.3h The new "bt_config.h"
//  2017.02.12 v0.3i Appended a Advertise on/off control and Disconnect request
//  2017.02.16 v0.3j Supported an advertise configure
//  2017.03.10 v0.4  Supported an AVDTP/Acceptor and A2DP/Sink(SBC codec, Require 32bit+FPU+200MIPS..)
//  2017.04.26 v0.4  Bug fix (L2CAP-RM:ACL-U send size)
//  2018.02.10 v0.4a Bug fix (SDP:ServiceSearchAttributeResponse, A2DP:media-sync-word)
//  2018.10.31 v0.4b Bug fix (Over the 1024 samples/MTU, support 48kHz sampling frequency)
//  2018.11.06 v0.4c Supported a notification to server APP
//  2018.11.18 v0.4c Bug fix (AVDTP disconnect state)
//  2019.02.09 v0.4d Bug fix (bt_att_db.h include relation)
//  2019.03.09 v0.4d Bug fix (L2CAP-RM:ACL-U packet size, etc...), SDP:Appended a "Service Name" to all profiles
//  2019.04.21 v0.4e Appended an A2DP APIs
//
#include "bt_process.h"                 // ADD 2016.04.21
#include "bt_rfcomm_server.h"           // ADD 2016.04.21  RFCOMM APIs
#include "bt_att_server.h"              // ADD 2016.04.21  ATT server APIs
#include "bt_att_db.h"                  // ADD 2016.04.21  ATT database APIs
#include "bt_spec_gatt.h"				// ADD 2019.02.09  GATT define
#include "bt_spec_att.h"				// ADD 2019.02.09  ATT define
#include "bt_l2cap_resource_manager.h"  // ADD 2016.04.21  Classic Secure APIs
#include "bt_security_manager.h"        // ADD 2016.04.21  LE Secure APIs
#include "bt_a2dp_sink.h"               // ADD 2017.03.10  A2DP APIs
