//
//  bt_a2dp_sink.h
//
//  Bluetooth Protocol Stack - A2DP (Advanced Audio Distribution Profile) Audio Sink application
//  Copyright (C) 2017-2019 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          Adopted Specifications
//          Traditional Profiles
//              Advanced Audio Distribution Profile (A2DP) 1.3
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2017.03.10 v0.0  First cording
//  2018.03.02 v0.0  Disconnect state
//  2018.10.31 v0.4b Bug fix (Over the 1024 samples/MTU, support 48kHz sampling frequency)
//  2019.04.21 v0.4e Appended an APIs
//
#ifndef BT_A2DP_SINK_H_
#define	BT_A2DP_SINK_H_

#include <stddef.h>

//
//	Configuration
//
  #define BT_A2DP_SINK_MAX_ENDPOINT			1       // <= 4
//#define BT_A2DP_SINK_BUFFER_NUM			4       //
//#define BT_A2DP_SINK_BUFFER_NUM			6       //
  #define BT_A2DP_SINK_BUFFER_NUM			8       //
  #define BT_A2DP_SINK_BUFFER_SIZE			1024    //
//#define BT_A2DP_SINK_TEMP_BUFFER_SIZE		1300	// ADD 2018.10.31  <Max sample count> / <L2CAP MTU>
  #define BT_A2DP_SINK_TEMP_BUFFER_SIZE		1500	// ADD 2018.10.31  <Max sample count> / <L2CAP MTU> + Safe
  #define BT_A2DP_SINK_DEFAULT_SAMPLING		44100	// ADD 2018.10.31
  #define BT_A2DP_SINK_DEFAULT_BIT_DEPTH	16		// ADD 2018.10.31
  #define BT_A2DP_SINK_DEFAULT_CHANNELS		2		// ADD 2018.10.31

//
//	Control block
//
struct bt_a2dp_endPoint {
	unsigned char	inUse;
	unsigned char	intSeid;
	int				samplingFrequency;	// ADD 2018.10.31  [Hz]
	int				bitDepth;			// ADD 2018.10.31  [bit/channel]
	int				channels;			// ADD 2018.10.31
	size_t			configLen;
	unsigned char	config[16];			// struct bt_avdtp_serviceCapabilitie
//	enum {
//		A2DP_EVENT_STOP,				// DEL 2018.03.02
//		A2DP_EVENT_START,				// DEL 2018.03.02
//		A2DP_EVENT_PAUSE,				// DEL 2018.03.02
//	}				event;				// DEL 2018.03.02
	enum {
		A2DP_STATE_DISCONNECT,			// ADD 2018.03.02
		A2DP_STATE_STOP,
		A2DP_STATE_PLAY,
	}				state;
//  short			pcmBuffer[BT_A2DP_SINK_BUFFER_NUM + 1][BT_A2DP_SINK_BUFFER_SIZE][2];    // DEL 2018.10.31  2=Stereo
	short			pcmBuffer[BT_A2DP_SINK_BUFFER_NUM][BT_A2DP_SINK_BUFFER_SIZE][2];        // ADD 2018.10.31  2=Stereo
	int				pcmLen[BT_A2DP_SINK_BUFFER_NUM];
	int				pcmWritePos;		// Free run counter
	int				pcmReadPos;			// Free run counter
};

extern struct bt_a2dp_endPoint bt_a2dp_endPoint[BT_A2DP_SINK_MAX_ENDPOINT];

//
//	API
// 										// ADD START 2019.04.21
#define			bt_a2dp_isAlive(seid)					(bt_a2dp_endPoint[(seid)-1].inUse)
#define			bt_a2dp_setSamplingFrequency(seid, fs)	bt_a2dp_endPoint[(seid)-1].samplingFrequency = (fs)
#define			bt_a2dp_setChannels(seid, ch)			bt_a2dp_endPoint[(seid)-1].channels = (ch)
extern short	*bt_a2dp_getPcmBuffer(int seid);		// seid:1..BT_A2DP_SINK_MAX_ENDPOINT
										// ADD START 2019.04.21
#endif
