//
//  bt_l2cap_resource_manager.h
//
//  Bluetooth Protocol Stack - L2CAP Resource Manager
//  Copyright (C) 2013-2016 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Summary:
//      Bluetooth controler link keeping
//      Message send/receive
//      Message segmentation/reassemble
//      Root task
//      Server function support only
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 4.0
//          [Vol 3] Core System Package [Host volume]
//          Part A: Logical Link Control and Adaptation Protocol Specification
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2014.03.05 v0.1a Change the USB process calling
//  2015.02.06 v0.3a Supported the Secure Simple Pairing
//  2016.02.12 v0.3c Appended a return code
//  2016.04.21 v0.3d Appended a API for SSP
//  2017.02.12 v0.3i Appended a Advertise on/off control and Disconnect request
//
#ifndef BT_L2CAP_RESOURCE_MANAGER_H_
#define BT_L2CAP_RESOURCE_MANAGER_H_
#include "bt_l2cap_cb_device.h"
#include "bt_l2cap_cb_common.h"                 // ADD 2016.04.21

//
//  API
//
//extern int bt_l2capResourceManager(void);     // CHG 2014.03.05
extern int bt_l2capResourceManager(int init);   // CHG 2014.03.05

//  Return code
//      >= 0 normal
#define BT_L2CAP_ERR_HCI_UNDEF_EVENT        1
#define BT_L2CAP_ERR_HCI_DEAD               -1
#define BT_L2CAP_ERR_HCI_HARDWARE           -2
#define BT_L2CAP_ERR_HCI_CMD_SEND_TIMEOUT   -3
#define BT_L2CAP_ERR_HCI_STAT_RECV_TIMEOUT  -4
#define BT_L2CAP_ERR_HCI_DATA_SEND_TIMEOUT  -5
#define BT_L2CAP_ERR_HCI_DATA_RECV_TIMEOUT  -6
#define BT_L2CAP_ERR_HCI_READ_LOCAL_VER     -7
#define BT_L2CAP_ERR_HCI_READ_BUFF_SIZE     -8
#define BT_L2CAP_ERR_HCI_READ_BDADDR        -9
#define BT_L2CAP_ERR_HCI_COMPATIBILITY      -10     // ADD 2015.02.06
#define BT_L2CAP_ERR_NOMEMORY               -11     // ADD 2016.02.12   Heap is shortage
#define BT_L2CAP_ERR_PASSKEY_TIMEOUT        -12     // ADD 2016.04.21

//  Call back routines                              // ADD START 2016.04.21
extern int  bt_l2capResourceManagerPinCodeRequest(struct bt_l2capDevice *dev, unsigned char pinCode[16]);   // PIN_Code_Length
extern int  bt_l2capResourceManagerNumericComparison(struct bt_l2capDevice *dev, long numericValue);        // OK=0 / NG=-1 / PENDING=-2
extern long bt_l2capResourceManagerPasskeyEntryInput(struct bt_l2capDevice *dev);                           // numericValue / NG=-1 / PENDING=-2
extern void bt_l2capResourceManagerPasskeyEntryDisplay(struct bt_l2capDevice *dev, long numericValue);      // 
                                                    // ADD END 2016.04.21

                                                    // ADD START 2017.02.12
//  int bt_l2capResourceManagerRequest(int request, void *parameter);   // Return code: busy=-1
#define bt_l2capResourceManagerRequest(a,b) ((bt_l2capCommon.resourceManagerRequest==0) ? (bt_l2capCommon.resourceManagerRequestParameter=(void *)(b),bt_l2capCommon.resourceManagerRequest=(a)) : -1)
#define BT_L2CAP_REQUEST_INQUIRY_SCAN_START 1       // NULL
#define BT_L2CAP_REQUEST_INQUIRY_SCAN_STOP  2       // NULL
#define BT_L2CAP_REQUEST_PAGE_SCAN_START    3       // NULL
#define BT_L2CAP_REQUEST_PAGE_SCAN_STOP     4       // NULL
#define BT_L2CAP_REQUEST_ADVERTISE_START    5       // NULL
#define BT_L2CAP_REQUEST_ADVERTISE_STOP     6       // NULL
#define BT_L2CAP_REQUEST_DISCONNECT         7       // link(set a reason code)
                                                    // ADD END 2017.02.12

#endif /* BT_L2CAP_RESOURCE_MANAGER_H_ */
