//
//  bt_security_manager.h
//
//  Bluetooth Protocol Stack - Security Manager
//  Copyright (C) 2014-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2014.02.23 v0.0  First cording
//  2014.03.05 v0.2  Commit
//  2017.01.03 v0.3e argument handle -> cb_channel
//  2017.01.18 v0.3f Appended a authentication function
//

#ifndef BT_SECURITY_MANAGER_H_
#define BT_SECURITY_MANAGER_H_

#include <string.h>
#include "bt_l2cap_cb_channel.h"        // Channel manage table     ADD 2017.01.03

extern size_t bt_securityManager(
//      unsigned short  handle,         // Communication handle     DEL 2017.01.03
        struct bt_l2capChannel *ch,     // Control block            ADD 2017.01.03
        unsigned char  *inBuff,
        size_t          inLen,
        unsigned char  *outBuff,
        size_t          outSize);
                                                                 // ADD START 2017.01.18
extern void bt_securityManagerKeyGeneration(
        unsigned char  *ltk,                        // Out
        unsigned char  *irk,                        // Out
        unsigned char  *csrk,                       // Out
        unsigned char  *ediv,                       // In(newDev=NULL) Out(Other)
        unsigned char  *rand,                       // In
        unsigned char  *newDiv);                    // In or NULL

extern void bt_securityManagerCrypt_ah(
        unsigned char *out,
        unsigned char *k,
        unsigned char *r);

//  Call back routines
extern long bt_securityManagerPasskeyInput(         // Return is a entered numeric value or -1(pending)
        struct bt_l2capChannel *ch);                // Security manager's Control block

extern long bt_securityManagerPasskeyCreateDisplay( // Return is a created numeric value (0-999999) or -2(reject)
        struct bt_l2capChannel *ch);                // Security manager's Control block
                                                                 // ADD END 2017.01.18
#endif /* BT_SECURITY_MANAGER_H_ */
