//
//  lcd_color.h	Part of Graphic LCD module I/O library, Primitive figure elements
//  Copyright(C)2013-2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.22 v0.0  First cording
//    2013.10.22 v0.1  Add color name
//    2014.01.09 v0.1  Changed a color code
//    2014.02.07 v0.1  Supported a LCD_LANDSCAPE_MODE
//    2014.03.15 v0.2  Rename source file: s95160_2.h -> lcd_draw.h + lcd_color.h
//

#ifndef LCD_COLOR_H_
#define LCD_COLOR_H_

//
// Color code
//                            rrrrrggggggbbbbb
#ifdef DEL											// DEL START 2014.01.09
#define LCD_COLOR_RED		0b1111100000000000
#define LCD_COLOR_PINK		0b1111100000001111
#define LCD_COLOR_MAGENTA	0b1111100000011111
#define LCD_COLOR_PURPLE	0b1110000000011111
#define LCD_COLOR_BLUE		0b0000000000011111
#define LCD_COLOR_CYAN		0b0000011111111111
#define LCD_COLOR_GREEN		0b0000011111100000
#define LCD_COLOR_LIME		0b0111111111100000
#define LCD_COLOR_YELLOW	0b1111111111100000
#define LCD_COLOR_ORANGE	0b1111101111100000
#define LCD_COLOR_BLACK		0b0000000000000000
#define LCD_COLOR_DARKGRAY	0b0011100111100111		// ADD 2013.10.22
#define LCD_COLOR_GRAY		0b0111101111101111
#define LCD_COLOR_LIGHTGRAY	0b1011110111110111		// ADD 2013.10.22
#define LCD_COLOR_WHITE		0b1111111111111111
#endif												// DEL END 2014.01.09
													// ADD START 2014.01.09
#define LCD_COLOR_CODE(r,g,b)	((((int)((r) * 31)) << 11) | (((int)((g) * 63)) << 5) | ((int)((b) * 31)))	// r,g,b=0..1
#define LCD_COLOR_TRANSPARENT	0b0000000000000000
#define LCD_COLOR_BLACK			0b0000000000000001
#define LCD_COLOR_LAMPBLACK		LCD_COLOR_CODE(0.14, 0.08, 0.05)
#define LCD_COLOR_DIMGRAY		LCD_COLOR_CODE(0.41, 0.41, 0.41)
#define LCD_COLOR_GRAY			LCD_COLOR_CODE(0.50, 0.50, 0.50)
#define LCD_COLOR_DARKGRAY		LCD_COLOR_CODE(0.66, 0.66, 0.66)
#define LCD_COLOR_LIGHTGRAY		LCD_COLOR_CODE(0.83, 0.83, 0.83)
#define LCD_COLOR_WHITE			LCD_COLOR_CODE(1.00, 1.00, 1.00)
#define LCD_COLOR_IVORY			LCD_COLOR_CODE(1.00, 1.00, 0.94)
#define LCD_COLOR_LAVENDER		LCD_COLOR_CODE(0.90, 0.90, 0.98)
#define LCD_COLOR_STEELBLUE		LCD_COLOR_CODE(0.27, 0.51, 0.71)
#define LCD_COLOR_DARKBLUE		LCD_COLOR_CODE(0.00, 0.00, 0.55)
#define LCD_COLOR_MIDNIGHTBLUE	LCD_COLOR_CODE(0.10, 0.10, 0.44)
#define LCD_COLOR_BLUE			LCD_COLOR_CODE(0.00, 0.00, 1.00)
#define LCD_COLOR_ROYALBLUE		LCD_COLOR_CODE(0.25, 0.41, 0.88)
#define LCD_COLOR_SKYBLUE		LCD_COLOR_CODE(0.53, 0.81, 0.92)
#define LCD_COLOR_MERMAIDBLUE	LCD_COLOR_CODE(0.65, 0.86, 0.89)
#define LCD_COLOR_LIGHTBLUE		LCD_COLOR_CODE(0.68, 0.85, 0.90)
#define LCD_COLOR_CYAN			LCD_COLOR_CODE(0.00, 1.00, 1.00)
#define LCD_COLOR_LIGHTCYAN		LCD_COLOR_CODE(0.88, 1.00, 1.00)
#define LCD_COLOR_DARKCYAN		LCD_COLOR_CODE(0.00, 0.55, 0.55)
#define LCD_COLOR_DARKGREEN		LCD_COLOR_CODE(0.00, 0.39, 0.00)
#define LCD_COLOR_GREEN			LCD_COLOR_CODE(0.00, 0.50, 0.00)
#define LCD_COLOR_FORESTGREEN	LCD_COLOR_CODE(0.13, 0.55, 0.13)
#define LCD_COLOR_SEAGREEN		LCD_COLOR_CODE(0.18, 0.55, 0.34)
#define LCD_COLOR_LIGHTGREEN	LCD_COLOR_CODE(0.56, 0.93, 0.56)
#define LCD_COLOR_GREENYELLOW	LCD_COLOR_CODE(0.68, 1.00, 0.18)
#define LCD_COLOR_LIME			LCD_COLOR_CODE(0.00, 1.00, 0.00)
#define LCD_COLOR_YELLOWGREEN	LCD_COLOR_CODE(0.60, 0.80, 0.20)
#define LCD_COLOR_OLIVEDRAB		LCD_COLOR_CODE(0.42, 0.56, 0.14)
#define LCD_COLOR_OLIVE			LCD_COLOR_CODE(0.50, 0.50, 0.00)
#define LCD_COLOR_TAN			LCD_COLOR_CODE(0.82, 0.71, 0.55)
#define LCD_COLOR_KHAKI			LCD_COLOR_CODE(0.94, 0.90, 0.55)
#define LCD_COLOR_YELLOW		LCD_COLOR_CODE(1.00, 1.00, 0.00)
#define LCD_COLOR_GOLD			LCD_COLOR_CODE(1.00, 0.84, 0.00)
#define LCD_COLOR_ORANGE		LCD_COLOR_CODE(1.00, 0.65, 0.00)
#define LCD_COLOR_CHOCOLATE		LCD_COLOR_CODE(0.82, 0.41, 0.12)
#define LCD_COLOR_DARKRED		LCD_COLOR_CODE(0.55, 0.00, 0.00)
#define LCD_COLOR_BROWN			LCD_COLOR_CODE(0.65, 0.16, 0.16)
#define LCD_COLOR_SALMON		LCD_COLOR_CODE(0.98, 0.50, 0.03)
#define LCD_COLOR_CORAL			LCD_COLOR_CODE(1.00, 0.50, 0.31)
#define LCD_COLOR_TOMATO		LCD_COLOR_CODE(1.00, 0.39, 0.28)
#define LCD_COLOR_RED			LCD_COLOR_CODE(1.00, 0.00, 0.00)
#define LCD_COLOR_DEEPPINK		LCD_COLOR_CODE(1.00, 0.08, 0.58)
#define LCD_COLOR_PINK			LCD_COLOR_CODE(1.00, 0.75, 0.80)
#define LCD_COLOR_MAGENTA		LCD_COLOR_CODE(1.00, 0.00, 1.00)
#define LCD_COLOR_VIOLET		LCD_COLOR_CODE(0.93, 0.51, 0.93)
#define LCD_COLOR_PURPLE		LCD_COLOR_CODE(0.50, 0.00, 0.50)
#define LCD_COLOR_INDIGO		LCD_COLOR_CODE(0.29, 0.00, 0.51)
#define LCD_COLOR_SLATEBLUE		LCD_COLOR_CODE(0.42, 0.35, 0.80)

#define LCD_COLOR_R_VALUE(code)		(((code) >> 11) / 31.0)							// Red component
#define LCD_COLOR_G_VALUE(code)		((((code) & 0b0000011111100000) >> 5) / 63.0)	// Green component
#define LCD_COLOR_B_VALUE(code)		(((code) & 0b0000000000011111) / 31.0)			// Blue component
#define LCD_COLOR_TO_DARK(code)		((unsigned short)LCD_COLOR_CODE(LCD_COLOR_R_VALUE(code)/2.0, LCD_COLOR_G_VALUE(code)/2.0, LCD_COLOR_B_VALUE(code)/2.0))
#define LCD_COLOR_TO_LIGHT(code)	((unsigned short)LCD_COLOR_CODE((LCD_COLOR_R_VALUE(code)+1.0)/2.0,(LCD_COLOR_G_VALUE(code)+1.0)/2.0,(LCD_COLOR_B_VALUE(code)+1.0)/2.0))

													// ADD END 2014.01.09
//
//	API
//
extern unsigned short	lcd_colorToLight(unsigned short color);
extern unsigned short	lcd_colorToDark(unsigned short color);

#endif /* LCD_COLOR_H_ */
