//
//  lcd_draw.h	Part of Graphic LCD module I/O library, Primitive figure display interface
//  Copyright(C)2013-2018 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.22 v0.0  First cording
//    2013.10.22 v0.1  Add color name
//    2014.01.09 v0.1  Changed a color code
//    2014.02.07 v0.1  Supported a LCD_LANDSCAPE_MODE
//    2014.03.15 v0.2  Rename source file: s95160_2.h -> lcd_draw.h + lcd_color.h
//    2014.03.16 v0.2  Add lcd_drawChar2(),lcd_drawStr2() and lcd_drawArc()
//    2018.01.19 v0.3  Supported a LCD_UPSIDE_DOWN_MODE
//

#ifndef LCD_DRAW_H_
#define LCD_DRAW_H_

#include "lcd_color.h"					// ADD 2014.03.15
#include "lcd_font.h"					// ADD 2014.03.15

//
//	Configuration
//
//#define LCD_PORTRATE_MODE				// ADD 2018.01.19  Display direction is vertical
#define LCD_LANDSCAPE_MODE				// ADD 2018.01.19  Display direction is horizontal
#define LCD_UPSIDE_DOWN_MODE			// ADD 2018.01.19  Display rotate 180deg

//
//	General parameter
//
#ifdef LCD_LANDSCAPE_MODE
#define LCD_SCREEN_WIDTH	320
#define LCD_SCREEN_HEIGHT	240
#else
#define LCD_SCREEN_WIDTH	240
#define LCD_SCREEN_HEIGHT	320
#endif

//
//	API
//
extern void	lcd_drawOpen(void);
extern void lcd_drawRect(short x, short y, short width, short height, unsigned short color);
extern void lcd_drawLine(short x1, short y1, short x2, short y2, short line_size, unsigned short color);
extern void lcd_drawImage(short x, short y, short width, short height, unsigned short *image);
extern void lcd_drawChar(short x, short y, unsigned short face_color, unsigned short back_color, char c);
extern void lcd_drawStr(short x, short y, unsigned short face_color, unsigned short back_color, char *str);
extern void lcd_drawInit(void);
extern void lcd_drawChar2(short x, short y, unsigned short face_color, unsigned short back_color, char c, const struct lcd_font *font);		// ADD 2014.03.16
extern void lcd_drawStr2(short x, short y, unsigned short face_color, unsigned short back_color, char *str, const struct lcd_font *font);	// ADD 2014.03.16
extern void lcd_drawArc(short x, short y, short r, float startRad, float endRad, short line_size, unsigned short color);					// ADD 2014.03.16


#endif /* LCD_DRAW_H_ */
