//
//  lcd_font.c	Part of Graphic LCD module I/O library, Font distributer
//  Copyright(C)2013-2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.22 v0.0  First cording
//    2014.02.07 v0.1  Supported a LCD_LANDSCAPE_MODE
//    2014.03.09 v0.1  If Line width > 1 then center
//    2014.03.15 v0.2  Source file: s95160_2.c -> s95160_2.c + lcd_font.c + lcd_font.h
//

#include <stddef.h>
#include "lcd_font.h"

//
//	Character font
//
const unsigned char lcd_font5x7[][7] = {
	{0b00000,	// " "
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	},
	{0b00100,	// !
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00000,
	 0b00100,
	 },
	{0b01010,	// "
	 0b01010,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 },
	{0b01010,	// #
	 0b01010,
	 0b11111,
	 0b01010,
	 0b01010,
	 0b11111,
	 0b01010,
	 },
	{0b00100,	// $
	 0b01111,
	 0b10100,
	 0b01110,
	 0b00101,
	 0b11111,
	 0b00100,
	 },
	{0b01001,	// %
	 0b10101,
	 0b01010,
	 0b00100,
	 0b01010,
	 0b10101,
	 0b10010,
	 },
	{0b01100,	// &
	 0b10010,
	 0b10100,
	 0b01000,
	 0b10101,
	 0b10010,
	 0b01101,
	 },
	{0b00100,	// '
	 0b00100,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 },
	{0b00010,	// (
	 0b00100,
	 0b01000,
	 0b01000,
	 0b01000,
	 0b00100,
	 0b00010,
	 },
	{0b01000,	// )
	 0b00100,
	 0b00010,
	 0b00010,
	 0b00010,
	 0b00100,
	 0b01000,
	 },
	{0b00000,	// *
	 0b00100,
	 0b10101,
	 0b01110,
	 0b10101,
	 0b00100,
	 0b00000,
	 },
	{0b00000,	// +
	 0b00100,
	 0b00100,
	 0b11111,
	 0b00100,
	 0b00100,
	 0b00000,
	 },
	{0b00000,	// ,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b01100,
	 0b00100,
	 0b01000,
	 },
	{0b00000,	// -
	 0b00000,
	 0b00000,
	 0b11111,
	 0b00000,
	 0b00000,
	 0b00000,
	 },
	{0b00000,	// .
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b01100,
	 0b01100,
	 },
	{0b00000,	// /
	 0b00001,
	 0b00010,
	 0b00100,
	 0b01000,
	 0b10000,
	 0b00000,
	 },
	{0b01110,	// 0
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b01110,
	 },
	{0b00100,	// 1
	 0b01100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 },
	{0b01110,	// 2
	 0b10001,
	 0b00001,
	 0b00010,
	 0b00100,
	 0b01000,
	 0b11111,
	 },
	{0b01110,	// 3
	 0b10001,
	 0b00001,
	 0b00110,
	 0b00001,
	 0b10001,
	 0b01110,
	 },
	{0b10010,	// 4
	 0b10010,
	 0b10010,
	 0b11111,
	 0b00010,
	 0b00010,
	 0b00010,
	 },
	{0b11111,	// 5
	 0b10000,
	 0b11110,
	 0b00001,
	 0b00001,
	 0b10001,
	 0b01110,
	 },
	{0b01110,	// 6
	 0b10001,
	 0b10000,
	 0b11110,
	 0b10001,
	 0b10001,
	 0b01110,
	 },
	{0b11111,	// 7
	 0b00001,
	 0b00010,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 },
	{0b01110,	// 8
	 0b10001,
	 0b10001,
	 0b01110,
	 0b10001,
	 0b10001,
	 0b01110,
	 },
	{0b01110,	// 9
	 0b10001,
	 0b10001,
	 0b01111,
	 0b00001,
	 0b10001,
	 0b01110,
	 },
	{0b00000,	// :
	 0b01100,
	 0b01100,
	 0b00000,
	 0b01100,
	 0b01100,
	 0b00000,
	 },
	{0b00000,	// ;
	 0b01100,
	 0b01100,
	 0b00000,
	 0b01100,
	 0b00100,
	 0b01000,
	 },
	{0b00010,	// <
	 0b00100,
	 0b01000,
	 0b10000,
	 0b01000,
	 0b00100,
	 0b00010,
	 },
	{0b00000,	// =
	 0b00000,
	 0b11111,
	 0b00000,
	 0b11111,
	 0b00000,
	 0b00000,
	 },
	{0b01000,	// >
	 0b00100,
	 0b00010,
	 0b00001,
	 0b00010,
	 0b00100,
	 0b01000,
	 },
	{0b01110,	// ?
	 0b10001,
	 0b00001,
	 0b00010,
	 0b00100,
	 0b00000,
	 0b00100,
	 },
	{0b01110,	// @
	 0b10001,
	 0b10111,
	 0b10101,
	 0b10111,
	 0b10000,
	 0b01110,
	 },
	{0b00100,	// A
	 0b01010,
	 0b10001,
	 0b10001,
	 0b11111,
	 0b10001,
	 0b10001,
	 },
	{0b11110,	// B
	 0b10001,
	 0b10001,
	 0b11110,
	 0b10001,
	 0b10001,
	 0b11110,
	 },
	{0b01110,	// C
	 0b10001,
	 0b10000,
	 0b10000,
	 0b10000,
	 0b10001,
	 0b01110,
	 },
	{0b11110,	// D
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b11110,
	 },
	{0b11111,	// E
	 0b10000,
	 0b10000,
	 0b11111,
	 0b10000,
	 0b10000,
	 0b11111,
	 },
	{0b11111,	// F
	 0b10000,
	 0b10000,
	 0b11111,
	 0b10000,
	 0b10000,
	 0b10000,
	 },
	{0b01110,	// G
	 0b10001,
	 0b10000,
	 0b10000,
	 0b10011,
	 0b10001,
	 0b01110,
	 },
	{0b10001,	// H
	 0b10001,
	 0b10001,
	 0b11111,
	 0b10001,
	 0b10001,
	 0b10001,
	 },
	{0b01110,	// I
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b01110,
	 },
	{0b00010,	// J
	 0b00010,
	 0b00010,
	 0b00010,
	 0b00010,
	 0b10010,
	 0b01100,
	 },
	{0b10001,	// K
	 0b10010,
	 0b10100,
	 0b11000,
	 0b10100,
	 0b10010,
	 0b10001,
	 },
	{0b10000,	// L
	 0b10000,
	 0b10000,
	 0b10000,
	 0b10000,
	 0b10000,
	 0b11111,
	 },
	{0b10001,	// M
	 0b11011,
	 0b10101,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 },
	{0b10001,	// N
	 0b10001,
	 0b11001,
	 0b10101,
	 0b10011,
	 0b10001,
	 0b10001,
	 },
	{0b01110,	// O
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b01110,
	 },
	{0b11110,	// P
	 0b10001,
	 0b10001,
	 0b11110,
	 0b10000,
	 0b10000,
	 0b10000,
	 },
	{0b01110,	// Q
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10101,
	 0b10010,
	 0b01101,
	 },
	{0b11110,	// R
	 0b10001,
	 0b10001,
	 0b11110,
	 0b10100,
	 0b10010,
	 0b10001,
	 },
	{0b01110,	// S
	 0b10001,
	 0b10000,
	 0b01110,
	 0b00001,
	 0b10001,
	 0b01110,
	 },
	{0b11111,	// T
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 },
	{0b10001,	// U
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b01110,
	 },
	{0b10001,	// V
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b01010,
	 0b00100,
	 },
	{0b10001,	// W
	 0b10001,
	 0b10001,
	 0b10101,
	 0b10101,
	 0b10101,
	 0b01010,
	 },
	{0b10001,	// X
	 0b10001,
	 0b01010,
	 0b00100,
	 0b01010,
	 0b10001,
	 0b10001,
	 },
	{0b10001,	// Y
	 0b01010,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 },
	{0b11111,	// Z
	 0b00001,
	 0b00010,
	 0b00100,
	 0b01000,
	 0b10000,
	 0b11111,
	 },
	{0b01110,	// [
	 0b01000,
	 0b01000,
	 0b01000,
	 0b01000,
	 0b01000,
	 0b01110,
	 },
	{0b00000,	// '\\'
	 0b10000,
	 0b01000,
	 0b00100,
	 0b00010,
	 0b00001,
	 0b00000,
	 },
	{0b01110,	// ]
	 0b00010,
	 0b00010,
	 0b00010,
	 0b00010,
	 0b00010,
	 0b01110,
	 },
	{0b00100,	// ^
	 0b01010,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 },
	{0b00000,	// _
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b11111,
	 },
	{0b01000,	// `
	 0b00100,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 },
	{0b00000,	// a
	 0b00000,
	 0b01110,
	 0b00001,
	 0b01111,
	 0b10011,
	 0b01101,
	 },
	{0b10000,	// b
	 0b10000,
	 0b10000,
	 0b11110,
	 0b10001,
	 0b10001,
	 0b11110,
	 },
	{0b00000,	// c
	 0b00000,
	 0b01111,
	 0b10000,
	 0b10000,
	 0b10000,
	 0b01111,
	 },
	{0b00001,	// d
	 0b00001,
	 0b00001,
	 0b01111,
	 0b10001,
	 0b10001,
	 0b01111,
	 },
	{0b00000,	// e
	 0b00000,
	 0b01110,
	 0b10001,
	 0b11111,
	 0b10000,
	 0b01110,
	 },
	{0b00011,	// f
	 0b00100,
	 0b00100,
	 0b01110,
	 0b00100,
	 0b00100,
	 0b00100,
	 },
	{0b00000,	// g
	 0b00000,
	 0b01110,
	 0b10001,
	 0b01111,
	 0b00001,
	 0b01110,
	 },
	{0b10000,	// h
	 0b10000,
	 0b10000,
	 0b11110,
	 0b10001,
	 0b10001,
	 0b10001,
	 },
	{0b00100,	// i
	 0b00000,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 },
	{0b00100,	// j
	 0b00000,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b11000,
	 },
	{0b10000,	// k
	 0b10000,
	 0b10001,
	 0b10010,
	 0b10100,
	 0b11010,
	 0b10001,
	 },
	{0b00100,	// l
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00110,
	 },
	{0b00000,	// m
	 0b00000,
	 0b11010,
	 0b10101,
	 0b10101,
	 0b10001,
	 0b10001,
	 },
	{0b00000,	// n
	 0b00000,
	 0b11110,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 },
	{0b00000,	// o
	 0b00000,
	 0b01110,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b01110,
	 },
	{0b00000,	// p
	 0b00000,
	 0b11110,
	 0b10001,
	 0b11110,
	 0b10000,
	 0b10000,
	 },
	{0b00000,	// q
	 0b00000,
	 0b01111,
	 0b10001,
	 0b01111,
	 0b00001,
	 0b00001,
	 },
	{0b00000,	// r
	 0b00000,
	 0b10111,
	 0b11000,
	 0b10000,
	 0b10000,
	 0b10000,
	 },
	{0b00000,	// s
	 0b00000,
	 0b01110,
	 0b10000,
	 0b01110,
	 0b00001,
	 0b01110,
	 },
	{0b00000,	// t
	 0b00100,
	 0b01110,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00010,
	 },
	{0b00000,	// u
	 0b00000,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b01111,
	 },
	{0b00000,	// v
	 0b00000,
	 0b10001,
	 0b10001,
	 0b10001,
	 0b01010,
	 0b00100,
	 },
	{0b00000,	// w
	 0b00000,
	 0b10001,
	 0b10001,
	 0b10101,
	 0b10101,
	 0b01010,
	 },
	{0b00000,	// x
	 0b00000,
	 0b10001,
	 0b01010,
	 0b00100,
	 0b01010,
	 0b10001,
	 },
	{0b00000,	// y
	 0b00000,
	 0b10001,
	 0b01010,
	 0b00100,
	 0b01000,
	 0b10000,
	 },
	{0b00000,	// z
	 0b00000,
	 0b11111,
	 0b00010,
	 0b00100,
	 0b01000,
	 0b11111,
	 },
	{0b00010,	// {
	 0b00100,
	 0b00100,
	 0b01000,
	 0b00100,
	 0b00100,
	 0b00010,
	 },
	{0b00100,	// |
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 0b00100,
	 },
	{0b01000,	// }
	 0b00100,
	 0b00100,
	 0b00010,
	 0b00100,
	 0b00100,
	 0b01000,
	 },
	{0b00000,	// ~
	 0b00000,
	 0b01000,
	 0b10101,
	 0b00010,
	 0b00000,
	 0b00000,
	 },
	{0b00100,	// deg
	 0b01010,
	 0b00100,
	 0b00000,
	 0b00000,
	 0b00000,
	 0b00000,
	 }
};
const unsigned char lcd_font7x11[][11] = {
	{0b0000000,	// " "
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	},
	{0b0001000,	// !
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0000000,
	 0b0000000,
	 0b0001000,
	 0b0001000,
	 },
	{0b0010100,	// "
	 0b0010100,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0010100,	// #
	 0b0010100,
	 0b0010100,
	 0b1111111,
	 0b0010100,
	 0b0010100,
	 0b0010100,
	 0b1111111,
	 0b0010100,
	 0b0010100,
	 0b0010100,
	 },
	{0b0001000,	// $
	 0b0111111,
	 0b1001000,
	 0b1001000,
	 0b1001000,
	 0b0111110,
	 0b0001001,
	 0b0001001,
	 0b0001001,
	 0b1111110,
	 0b0001000,
	 },
	{0b0110000,	// %
	 0b1001001,
	 0b1001001,
	 0b0110010,
	 0b0000101,
	 0b0001000,
	 0b0010000,
	 0b0100110,
	 0b1001001,
	 0b1001001,
	 0b0000110,
	 },
	{0b0011100,	// &
	 0b0100010,
	 0b1000010,
	 0b1000100,
	 0b0101000,
	 0b0010000,
	 0b0110000,
	 0b1001000,
	 0b1000101,
	 0b1000010,
	 0b0111101,
	 },
	{0b0001000,	// '
	 0b0010000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0000100,	// (
	 0b0001000,
	 0b0010000,
	 0b0010000,
	 0b0100000,
	 0b0100000,
	 0b0100000,
	 0b0010000,
	 0b0010000,
	 0b0001000,
	 0b0000100,
	 },
	{0b0010000,	// )
	 0b0001000,
	 0b0000100,
	 0b0000100,
	 0b0000010,
	 0b0000010,
	 0b0000010,
	 0b0000100,
	 0b0000100,
	 0b0001000,
	 0b0010000,
	 },
	{0b0000000,	// *
	 0b0001000,
	 0b1001001,
	 0b0101010,
	 0b0011100,
	 0b0001000,
	 0b0011100,
	 0b0101010,
	 0b1001001,
	 0b0001000,
	 0b0000000,
	 },
	{0b0000000,	// +
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b1111111,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0000000,
	 },
	{0b0000000,	// ,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011000,
	 0b0011000,
	 0b0001000,
	 0b0010000,
	 },
	{0b0000000,	// -
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1111111,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0000000,	// .
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011000,
	 0b0011000,
	 },
	{0b0000000,	// /
	 0b0000000,
	 0b0000001,
	 0b0000010,
	 0b0000100,
	 0b0001000,
	 0b0010000,
	 0b0100000,
	 0b1000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0011100,	// 0
	 0b0100010,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b0001000,	// 1
	 0b0011000,
	 0b0101000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 },
	{0b0011100,	// 2
	 0b0100010,
	 0b1000001,
	 0b0000001,
	 0b0000010,
	 0b0000100,
	 0b0001000,
	 0b0010000,
	 0b0100000,
	 0b1000000,
	 0b1111111,
	 },
	{0b0011100,	// 3
	 0b0100010,
	 0b1000001,
	 0b0000001,
	 0b0000010,
	 0b0001100,
	 0b0000010,
	 0b0000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b0000100,	// 4
	 0b0001100,
	 0b0001100,
	 0b0010100,
	 0b0010100,
	 0b0100100,
	 0b0100100,
	 0b1000100,
	 0b1111111,
	 0b0000100,
	 0b0000100,
	 },
	{0b1111111,	// 5
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1111100,
	 0b0000010,
	 0b0000001,
	 0b0000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b0011110,	// 6
	 0b0100001,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1111100,
	 0b1000010,
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b1111111,	// 7
	 0b0000001,
	 0b0000010,
	 0b0000010,
	 0b0000100,
	 0b0000100,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 },
	{0b0011100,	// 8
	 0b0100010,
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 0b0100010,
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b0011100,	// 9
	 0b0100010,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0100011,
	 0b0011101,
	 0b0000001,
	 0b0000001,
	 0b0000010,
	 0b0111100,
	 },
	{0b0000000,	// :
	 0b0000000,
	 0b0011000,
	 0b0011000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011000,
	 0b0011000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0000000,	// ;
	 0b0000000,
	 0b0011000,
	 0b0011000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011000,
	 0b0001000,
	 0b0010000,
	 0b0000000,
	 },
	{0b0000010,	// <
	 0b0000100,
	 0b0001000,
	 0b0010000,
	 0b0100000,
	 0b1000000,
	 0b0100000,
	 0b0010000,
	 0b0001000,
	 0b0000100,
	 0b0000010,
	 },
	{0b0000000,	// =
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1111111,
	 0b0000000,
	 0b1111111,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0100000,	// >
	 0b0010000,
	 0b0001000,
	 0b0000100,
	 0b0000010,
	 0b0000001,
	 0b0000010,
	 0b0000100,
	 0b0001000,
	 0b0010000,
	 0b0100000,
	 },
	{0b0011100,	// ?
	 0b0100010,
	 0b1000001,
	 0b0000001,
	 0b0000010,
	 0b0000100,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0000000,
	 0b0001000,
	 },
	{0b0011100,	// @
	 0b0100010,
	 0b1000001,
	 0b1001111,
	 0b1010001,
	 0b1010001,
	 0b1010001,
	 0b1001110,
	 0b1000000,
	 0b0100001,
	 0b0011110,
	 },
	{0b0001000,	// A
	 0b0001000,
	 0b0010100,
	 0b0010100,
	 0b0010100,
	 0b0100010,
	 0b0100010,
	 0b0111110,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 },
	{0b1111100,	// B
	 0b1000010,
	 0b1000001,
	 0b1000001,
	 0b1000010,
	 0b1111100,
	 0b1000010,
	 0b1000001,
	 0b1000001,
	 0b1000010,
	 0b1111100,
	 },
	{0b0011100,	// C
	 0b0100010,
	 0b1000001,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b1111100,	// D
	 0b1000010,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000010,
	 0b1111100,
	 },
	{0b1111111,	// E
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1111111,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1111111,
	 },
	{0b1111111,	// F
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1111111,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 },
	{0b0011100,	// G
	 0b0100010,
	 0b1000001,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000111,
	 0b1000001,
	 0b1000001,
	 0b0100011,
	 0b0011101,
	 },
	{0b1000001,	// H
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1111111,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 },
	{0b0011100,	// I
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0011100,
	 },
	{0b0000100,	// J
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b1000100,
	 0b0111000,
	 },
	{0b1000001,	// K
	 0b1000010,
	 0b1000100,
	 0b1001000,
	 0b1010000,
	 0b1100000,
	 0b1010000,
	 0b1001000,
	 0b1000100,
	 0b1000010,
	 0b1000001,
	 },
	{0b1000000,	// L
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1111111,
	 },
	{0b1000001,	// M
	 0b1100011,
	 0b1010101,
	 0b1001001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 },
	{0b1000001,	// N
	 0b1000001,
	 0b1100001,
	 0b1010001,
	 0b1010001,
	 0b1001001,
	 0b1000101,
	 0b1000101,
	 0b1000011,
	 0b1000001,
	 0b1000001,
	 },
	{0b0111110,	// O
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0111110,
	 },
	{0b1111100,	// P
	 0b1000010,
	 0b1000001,
	 0b1000001,
	 0b1000010,
	 0b1111100,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 },
	{0b0011100,	// Q
	 0b0100010,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1001001,
	 0b1000101,
	 0b0100010,
	 0b0011101,
	 },
	{0b1111100,	// R
	 0b1000010,
	 0b1000001,
	 0b1000001,
	 0b1000010,
	 0b1111100,
	 0b1010000,
	 0b1001000,
	 0b1000100,
	 0b1000010,
	 0b1000001,
	 },
	{0b0011110,	// S
	 0b0100001,
	 0b1000000,
	 0b1000000,
	 0b0100000,
	 0b0011100,
	 0b0000010,
	 0b0000001,
	 0b0000001,
	 0b1000010,
	 0b0111100,
	 },
	{0b1111111,	// T
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 },
	{0b1000001,	// U
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b1000001,	// V
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0100010,
	 0b0100010,
	 0b0010100,
	 0b0010100,
	 0b0010100,
	 0b0001000,
	 0b0001000,
	 },
	{0b1000001,	// W
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1001001,
	 0b1001001,
	 0b1010101,
	 0b0100010,
	 0b0100010,
	 },
	{0b1000001,	// X
	 0b1000001,
	 0b0100010,
	 0b0010100,
	 0b0010100,
	 0b0001000,
	 0b0010100,
	 0b0010100,
	 0b0100010,
	 0b1000001,
	 0b1000001,
	 },
	{0b1000001,	// Y
	 0b0100010,
	 0b0100010,
	 0b0010100,
	 0b0010100,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 },
	{0b1111111,	// Z
	 0b0000001,
	 0b0000010,
	 0b0000010,
	 0b0000100,
	 0b0001000,
	 0b0010000,
	 0b0100000,
	 0b0100000,
	 0b1000000,
	 0b1111111,
	 },
	{0b0011100,	// [
	 0b0010000,
	 0b0010000,
	 0b0010000,
	 0b0010000,
	 0b0010000,
	 0b0010000,
	 0b0010000,
	 0b0010000,
	 0b0010000,
	 0b0011100,
	 },
	{0b1000000,	// '\\'
	 0b1000000,
	 0b0100000,
	 0b0010000,
	 0b0010000,
	 0b0001000,
	 0b0000100,
	 0b0000100,
	 0b0000010,
	 0b0000001,
	 0b0000001,
	 },
	{0b0011100,	// ]
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0000100,
	 0b0011100,
	 },
	{0b0001000,	// ^
	 0b0010100,
	 0b0100010,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0000000,	// _
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1111111,
	 },
	{0b0010000,	// `
	 0b0001000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0000000,	// a
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0111110,
	 0b1000001,
	 0b0000001,
	 0b0111111,
	 0b1000001,
	 0b1000011,
	 0b0111101,
	 },
	{0b1000000,	// b
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1011100,
	 0b1100010,
	 0b1000001,
	 0b1000001,
	 0b1000010,
	 0b1111100,
	 },
	{0b0000000,	// c
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011110,
	 0b0100001,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b0100001,
	 0b0011110,
	 },
	{0b0000001,	// d
	 0b0000001,
	 0b0000001,
	 0b0000001,
	 0b0000001,
	 0b0011111,
	 0b0100001,
	 0b1000001,
	 0b1000001,
	 0b0100011,
	 0b0011101,
	 },
	{0b0000000,	// e
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011100,
	 0b0100010,
	 0b1000001,
	 0b1111111,
	 0b1000000,
	 0b0100000,
	 0b0011110,
	 },
	{0b0000110,	// f
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0011100,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 },
	{0b0000000,	// g
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011100,
	 0b0100010,
	 0b1000001,
	 0b0111111,
	 0b0000001,
	 0b1000001,
	 0b0111110,
	 },
	{0b1000000,	// h
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1011100,
	 0b1100010,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 },
	{0b0000000,	// i
	 0b0000000,
	 0b0001000,
	 0b0000000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 },
	{0b0000000,	// j
	 0b0000000,
	 0b0001000,
	 0b0000000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0110000,
	 },
	{0b1000000,	// k
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000001,
	 0b1000010,
	 0b1000100,
	 0b1001000,
	 0b1010100,
	 0b1100010,
	 0b1000001,
	 },
	{0b0000000,	// l
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0000100,
	 },
	{0b0000000,	// m
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1110110,
	 0b1001001,
	 0b1001001,
	 0b1001001,
	 0b1001001,
	 0b1001001,
	 0b1001001,
	 },
	{0b0000000,	// n
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1011100,
	 0b1100010,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 },
	{0b0000000,	// o
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0011100,
	 0b0100010,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0011100,
	 },
	{0b0000000,	// p
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1111110,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1111110,
	 0b1000000,
	 0b1000000,
	 },
	{0b0000000,	// q
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0111111,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0111111,
	 0b0000001,
	 0b0000001,
	 },
	{0b0000000,	// r
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1011111,
	 0b1100000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 0b1000000,
	 },
	{0b0000000,	// s
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0111110,
	 0b1000001,
	 0b1000000,
	 0b0111110,
	 0b0000001,
	 0b1000001,
	 0b0111110,
	 },
	{0b0000000,	// t
	 0b0000000,
	 0b0000000,
	 0b0001000,
	 0b0001000,
	 0b0011100,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0000110,
	 },
	{0b0000000,	// u
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0100011,
	 0b0011101,
	 },
	{0b0000000,	// v
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b1000001,
	 0b0100010,
	 0b0010100,
	 0b0001000,
	 },
	{0b0000000,	// w
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1001001,
	 0b1001001,
	 0b1001001,
	 0b1001001,
	 0b1001001,
	 0b1010101,
	 0b0100010,
	 },
	{0b0000000,	// x
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1000001,
	 0b0100010,
	 0b0010100,
	 0b0001000,
	 0b0010100,
	 0b0100010,
	 0b1000001,
	 },
	{0b0000000,	// y
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1000001,
	 0b0100010,
	 0b0010100,
	 0b0001000,
	 0b0010000,
	 0b0100000,
	 0b1000000,
	 },
	{0b0000000,	// z
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b1111111,
	 0b0000010,
	 0b0000100,
	 0b0001000,
	 0b0010000,
	 0b0100000,
	 0b1111111,
	 },
	{0b0000110,	// {
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0110000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0000110,
	 },
	{0b0001000,	// |
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 },
	{0b0110000,	// }
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0000110,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0001000,
	 0b0110000,
	 },
	{0b0000000,	// ~
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0110000,
	 0b1001001,
	 0b0000110,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 },
	{0b0011000,	// deg
	 0b0100100,
	 0b0100100,
	 0b0011000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 0b0000000,
	 }
};

const struct lcd_font	lcd_fontTable[] = {
		{lcd_font5x7,  0, 5,  7,  1,  6,  8},
		{lcd_font7x11, 0, 7, 11,  1,  8, 12},
		{lcd_font5x7,  0, 5,  7,  2, 12, 16},
		{lcd_font7x11, 0, 7, 11,  2, 16, 24},
		{lcd_font5x7,  0, 5,  7,  3, 18, 24},
		{lcd_font7x11, 0, 7, 11,  3, 24, 36},
		{lcd_font5x7,  0, 5,  7,  4, 24, 32},
		{lcd_font7x11, 0, 7, 11,  4, 32, 48},
		{NULL}
};

unsigned int	lcd_fontPattern[48];

unsigned int *lcd_fontGetPattern(const struct lcd_font *font, char c){
	unsigned char	*in;
	unsigned int	*out;
	int				i;
	int 			exp;
	int				lim;
	unsigned int	img;

	in  = (unsigned char *)(font->pattern) + (((c & 0x7f) - ' ') * font->charUnit);
	out = lcd_fontPattern;
	exp = 0;
	img = 0;
	for(i = font->height, lim = font->charUnit * font->expand; i > 0; --i, --lim) {

		if (--exp <= 0) {
			unsigned int	fm;
			unsigned int	fm2;
			int				k;
			unsigned char	c;
			unsigned char	cm;

			img = 0;
			c = *in++;
			cm = 1 << (font->validBit - 1);
			fm = 1 << (font->width - 1);
			for(k = font->expand, fm2 = 0; k > 0 ; --k) {
				fm2 >>= 1;
				fm2 |= fm;
			}
			for(k = font->validBit; k > 0 ; --k) {
				if (c & cm) {
					img |= fm2;
				}
				fm2 = fm2 >> (font->expand);
				cm  = cm >> 1;
			}
			exp = font->expand;
		}

		if (lim > 0) {
			*out++ = img;
		} else {
			*out++ = 0;
		}
	}
	return(lcd_fontPattern);
}
