//
//  lcd_font.h	Part of Graphic LCD module I/O library, Font distributer
//  Copyright(C)2013-2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.22 v0.0  First cording
//    2014.02.07 v0.1  Supported a LCD_LANDSCAPE_MODE
//    2014.03.09 v0.1  If Line width > 1 then center
//    2014.03.15 v0.2  Source file: s95160_2.c -> s95160_2.c + lcd_font.c + lcd_font.h
//

#ifndef LCD_FONT_H_
#define LCD_FONT_H_
#include <stddef.h>						// size_t

//
//	Default font (Old style)
//
#define LCD_FONT_WIDTH		6
#define LCD_FONT_HEIGHT		8
extern const unsigned char	lcd_font5x7[][7];

//
//	Control block
//
struct lcd_font {
	void	*pattern;
	size_t	varSize;		// Pattern var type
	int		validBit;		// Pattern LSB-
	int		charUnit;		// Pattern Byte
	int		expand;			//
	int		width;			// Pixel
	int		height;			// Pixel
};
extern const struct lcd_font	lcd_fontTable[];

//
//	Font name
//
#define	LCD_FONT_6x8	&(lcd_fontTable[0])
#define	LCD_FONT_8x12	&(lcd_fontTable[1])
#define	LCD_FONT_12x16	&(lcd_fontTable[2])
#define	LCD_FONT_16x24	&(lcd_fontTable[3])
#define	LCD_FONT_18x24	&(lcd_fontTable[4])
#define	LCD_FONT_24x36	&(lcd_fontTable[5])
#define	LCD_FONT_24x32	&(lcd_fontTable[6])
#define	LCD_FONT_32x48	&(lcd_fontTable[7])

//
//	API
//
extern unsigned int	*lcd_fontGetPattern(const struct lcd_font *font, char c);
#define 			lcd_fontGetWidth(font)		(font->varWidth)
#define 			lcd_fontGetHeight(font)		(font->varHeight)

#endif /* LCD_FONT_H_ */
