//
//  lcd_gui.c	  GUI support library
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//
//

#include "lcd_gui_display.h"
#include "lcd_gui_touch.h"
#include "lcd_gui_manage.h"

//
//	Task handler
//
#ifdef V01B
void lcd_guiHandler(struct lcd_guiRoot *root){
	static struct lcd_guiCoordinate	base = {0,0};

	if (lcd_guiGlobalFlags.dirty) {
		if (!lcd_guiDisplay(root, &base)) {
			lcd_guiGlobalFlags.dirty = 0;
		}
	}
	lcd_guiHandlerTouch(root);
	return;
}
#else

struct lcd_guiGlobalFlags	lcd_guiGlobalFlags = {1};
static int					state;

void lcd_guiHandler(struct lcd_guiRoot *root){
	static struct lcd_guiCoordinate	base  = {0,0};
//	static int						state = 0;

	switch(state) {
	case 0:
		if (lcd_guiGlobalFlags.dirty) {
//			lcd_guiSetGroupDirtyWalk(root);
			lcd_guiGlobalFlags.dirty = 0;
			state = 1;
		} else {
			state = 2;
		}
		break;
	case 1:
		lcd_guiDisplay((struct lcd_gui *)root, &base);
		state = 0;
		break;
	case 2:
		lcd_guiHandlerTouch((struct lcd_gui *)root);
		state = 0;
		break;
	default:
		break;
	}

	return;
}
#endif
