//
//  lcd_gui.h	  GUI support library
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//
//		Refer:
//			lcd_gui_figure.h:  Primitive figure segment
//			lcd_gui_display.h: Display control
//			lcd_gui_touch.h:   Touch action control
//			lcd_gui_manage.h:  Management of figure segment
//			lcd_gui_create*.h: New figure segment
//

#ifndef LCD_GUI_H_
#define LCD_GUI_H_

#include "lcd_gui_figure.h"				// Basic figures
#include "lcd_gui_manage.h"				//
#include "lcd_gui_create.h"				//
#include "lcd_gui_create_button.h"		//
#include "lcd_gui_create_pulldown.h"	//
#include "lcd_gui_create_textfield.h"	//
#include "lcd_gui_create_integerfield.h"//
#include "lcd_gui_create_floatfield.h"	//
#include "lcd_draw.h"					//
#include "lcd_touch.h"					//

//
//	API
//
#define			lcd_guiOpen()		(lcd_drawOpen(), lcd_touchOpen())
extern void		lcd_guiHandler(struct lcd_guiRoot *root);

#endif /* LCD_GUI_H_ */
