//
//  lcd_gui_create_button.h	  Part of GUI support library, Button object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//
//

#ifndef LCD_GUI_CREATE_BUTTON_H_
#define LCD_GUI_CREATE_BUTTON_H_

#include "lcd_gui_figure.h"
#include <stddef.h>
#include "lcd_color.h"


//
//	Control block
//
struct lcd_guiButton {
	struct lcd_guiGroup grp;			// Essential item
	unsigned short		normalColor;
	unsigned short		touchedColor;
	struct lcd_guiButtonAttr {
		unsigned int		alternateMode:	1;
		unsigned int		state:			1;
	}					attr;
	void				(*actionProg)(struct lcd_guiButton *s);
	struct lcd_guiText	*capSeg;
};

//
//	API	- Static memory functions
//
// Initialization parameter macro
#define LCD_GUI_INIT_BUTTON(next,prev,x,y,width,height,cap,font,face,back,touch,mode,state,eventProg,figs,capSeg)	{\
		LCD_GUI_INIT_GROUP(next,prev,x,y,width,height,LCD_COLOR_TO_LIGHT(back),figs,lcd_guiTouchButton),\
		back,\
		touch,\
		{mode,state},\
		eventProg,\
		capSeg,\
}
struct lcd_guiButtonSet {
	struct lcd_guiButton	button;
	struct lcd_guiParent	p;
	struct lcd_guiRect		r1;
	struct lcd_guiRect		r2;
	struct lcd_guiText		t;
};
#define LCD_GUI_INIT_BUTTON_SET(name,next,prev,x,y,width,height,cap,font,face,back,touch,mode,state,eventProg)	{\
		LCD_GUI_INIT_BUTTON(next,prev,x,y,width,height,cap,font,face,back,touch,mode,state,eventProg,&(name.p),&(name.t)),\
		LCD_GUI_INIT_PARENT(&(name.r1),NULL,NULL),\
		LCD_GUI_INIT_RECT(&(name.r2),NULL,width-2,0,2,height-2,LCD_COLOR_TO_DARK(back)),\
		LCD_GUI_INIT_RECT(&(name.t),NULL,0,height-2,width,2,LCD_COLOR_TO_DARK(back)),\
		LCD_GUI_INIT_TEXT(NULL,NULL,2,2,width-4,height-4,face,back,LCD_GUI_TEXT_ALIGN_CENTER,LCD_GUI_TEXT_ALIGN_CENTER,cap,font),\
};
//	ex:
//		void buttonSub(struct lcd_guiButton *b) {
//			printf("Push!\n");
//		}
//		struct lcd_guiButtonSet	btn1 = LCD_GUI_INIT_BUTTON_SET(btn, NULL, NULL, 100, 200, 40, 30, "Test", LCD_FONT_6x8, LCD_COLOR_LIME, LCD_COLOR_GRAY, LCD_COLOR_SKYBLUE, 0, 0, buttonSub);
//		struct lcd_guiRootSet	root = LCD_GUI_INIT_ROOT_SET(root, LCD_COLOR_BLACK, &btn1, NULL);


//
//	API	- Dynamic memory functions
//
enum lcd_guiButtonMode {
	LCD_GUI_BUTTON_MODE_MOMENTARY = 0,
	LCD_GUI_BUTTON_MODE_ALTERNATE
};
//extern struct lcd_guiButton	*lcd_guiAllocButton(struct lcd_guiGroup *parent);
extern struct lcd_guiButton		*lcd_guiInitButton(struct lcd_guiButton *alloc, short x, short y, short width, short height, char *caption, const struct lcd_font *font, unsigned short faceColor, unsigned short backColor, unsigned short touchColor, enum lcd_guiButtonMode mode, int state, void (*actionProg)(struct lcd_guiButton *seg));
//extern struct lcd_guiButton	*lcd_guiNewButton(struct lcd_guiGroup *parent, short x, short y, short width, short height, char *caption, const struct lcd_font *font, unsigned short faceColor, unsigned short backColor, unsigned short touchColor, enum lcd_guiButtonMode mode, int state, void (*actionProg)(struct lcd_guiButton *seg));
extern void						lcd_guiSetButtonState(struct lcd_guiButton *button, int state);


//
//	Internal
//
extern void lcd_guiTouchButton(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *seg);
#define lcd_guiAllocButton(b)									((struct lcd_guiButton*)lcd_guiAlloc((struct lcd_guiGroup *)(b), sizeof(struct lcd_guiButton)))
#define lcd_guiNewButton(b,x,y,w,h,c,f,c1,c2,c3,m,s,func)		lcd_guiInitButton(lcd_guiAllocButton(b), x,y,w,h,c,f,c1,c2,c3,m,s,func)

#endif /* LCD_GUI_CREATE_BUTTON_H_ */
