//
//  lcd_gui_create_floatfield.h	  Part of GUI support library, Float number field object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#ifndef LCD_GUI_CREATE_FLOATFIELD_H_
#define LCD_GUI_CREATE_FLOATFIELD_H_

#include "lcd_gui_figure.h"
#include <stddef.h>
#include "lcd_color.h"

//
//	Configuration
//
#define LCD_GUI_FLOAT_FIELD_TENKEY_SIZE_W			150
#define LCD_GUI_FLOAT_FIELD_TENKEY_SIZE_H			150

//
//	Control block
//
struct lcd_guiFloatField {
	struct lcd_guiGroup 		grp;			// Essential item
	char						*format;
	float						min;
	float						max;
	float						value;
	void						(*actionProg)(struct lcd_guiFloatField *s);
	char						buff[16];
};

//
//	API	- Static memory functions
//
// Initialization parameter macro
#define LCD_GUI_INIT_FLOAT_FIELD(next,prev,x,y,width,height,face,back,format,font,min,max,value,eventProg,figs)	{\
	LCD_GUI_INIT_GROUP(next,prev,x,y,width,height,LCD_COLOR_TO_DARK(back),figs,lcd_guiTouchFloatField),\
	format,\
	min,\
	max,\
	value,\
	eventProg,\
	""\
}
struct lcd_guiFloatFieldSet {
	struct lcd_guiFloatField	floatField;
	struct lcd_guiParent		p;
	struct lcd_guiRect			r1;
	struct lcd_guiRect			r2;
	struct lcd_guiText			t;
};
#define LCD_GUI_INIT_FLOAT_FIELD_SET(name,next,prev,x,y,width,height,face,back,format,font,min,max,value,eventProg)	{\
	LCD_GUI_INIT_FLOAT_FIELD(next,prev,x,y,width,height,face,back,format,font,min,max,value,eventProg,&(name.p)),\
	LCD_GUI_INIT_PARENT(&(name.r1), NULL, NULL),\
	LCD_GUI_INIT_RECT(&(name.r2), NULL, width-1, 0, 1, height-1, LCD_COLOR_TO_LIGHT(back)),\
	LCD_GUI_INIT_RECT(&(name.t), NULL, 0, height-1, width, 1, LCD_COLOR_TO_LIGHT(back)),\
	LCD_GUI_INIT_TEXT(NULL, NULL, 1, 1, width-2, height-2, face,back,LCD_GUI_TEXT_ALIGN_RIGHT,LCD_GUI_TEXT_ALIGN_CENTER,name.floatField.buff,font),\
};
//	ex:
//		void floatFieldSub(struct lcd_guiFloatField *b) {
//			printf("Float Update!\n");
//		}
//		struct lcd_guiFloatFieldSet	fld1 = LCD_GUI_INIT_FLOAT_FIELD_SET(fld1, NULL, NULL, 100, 200, 40, 30, LCD_COLOR_LIME, LCD_COLOR_GRAY, "%4.2f", LCD_FONT_6x8, 0, 1000.0, 9.9, floatFieldSub);
//		struct lcd_guiRootSet		root = LCD_GUI_INIT_ROOT_SET(root, LCD_COLOR_BLACK, &fld1, NULL);


//
//	API	- Dynamic memory functions
//
//extern struct lcd_guiFloatField	*lcd_guiAllocFloatField(struct lcd_guiGroup *parent);
extern struct lcd_guiFloatField	*lcd_guiInitFloatField(struct lcd_guiFloatField *alloc, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, char *format, const struct lcd_font *font, float min, float max, float value, void (*actionProg)(struct lcd_guiFloatField *seg));
//extern struct lcd_guiFloatField	*lcd_guiNewFloatField(struct lcd_guiGroup *parent, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, char *format, const struct lcd_font *font, float min, float max, float value, void (*actionProg)(struct lcd_guiFloatField *seg));
extern int							lcd_guiSetFloatFieldValue(struct lcd_guiFloatField *g, float f);


//
//	Internal
//
extern void lcd_guiTouchFloatField(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *seg);
#define lcd_guiAllocFloatField(b)									(struct lcd_guiFloatField*)lcd_guiAlloc((struct lcd_guiGroup *)(b), sizeof(struct lcd_guiFloatField))
#define lcd_guiNewFloatField(b,x,y,w,h,c1,c2,f,fnt,min,max,v,func)	lcd_guiInitFloatField(lcd_guiAllocFloatField(b),x,y,w,h,c1,c2,f,fnt,min,max,v,func)


#endif /* LCD_GUI_CREATE_FLOATFIELD_H_ */
