//
//  lcd_gui_create_keypad.h	  Part of GUI support library, Pop up key pad object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#ifndef LCD_GUI_CREATE_KEYPAD_H_
#define LCD_GUI_CREATE_KEYPAD_H_

#include "lcd_gui_figure.h"
#include "lcd_gui_create_button.h"		// lcd_guiNewButton()
#include "lcd_color.h"
#include "lcd_font.h"

//
//	Configuration
//
#define LCD_GUI_KEYPAD_SHIFT_INIT		1
#define LCD_GUI_KEYPAD_COLOR_FACE		LCD_COLOR_WHITE
#define LCD_GUI_KEYPAD_COLOR_BACK		LCD_COLOR_GRAY
#define LCD_GUI_KEYPAD_COLOR_TOUCH		LCD_COLOR_ROYALBLUE
#define LCD_GUI_KEYPAD_FONT				LCD_FONT_6x8

//
// Control block
//
struct lcd_guiKeyPad {
	struct lcd_guiGroup 		grp;			// Essential item
	int							shift;
	void						*targetField;
};

//
// API
//
enum lcd_guiKeyPadType {
	LCD_GUI_KEYPAD_TYPE_ASCII = 1,
	LCD_GUI_KEYPAD_TYPE_TENKEY,
};
//extern struct lcd_guiKeyPad	*lcd_guiAllocKeyPad(struct lcd_guiGroup *parent);
extern struct lcd_guiKeyPad		*lcd_guiInitKeyPad(struct lcd_guiKeyPad *alloc, short x, short y, short width, short height, enum lcd_guiKeyPadType type, void (*callBack)(struct lcd_guiButton *seg), void *target);
//extern struct lcd_guiKeyPad	*lcd_guiNewKeyPad(struct lcd_guiGroup *parent, short x, short y, short width, short height, enum lcd_guiKeyPadType type, void (*callBack)(struct lcd_guiButton *seg), void *target);
//extern int					lcd_guiGetKeyPadShift(struct lcd_guiKeyPad *alloc);
//extern void					lcd_guiSetKeyPadShift(struct lcd_guiKeyPad *alloc, int state);
//extern void					*lcd_guiGetKeyPadTargetField(struct lcd_guiKeyPad *alloc);

#define lcd_guiAllocKeyPad(a)							((struct lcd_guiKeyPad*)lcd_guiAlloc((struct lcd_guiGroup *)(a), sizeof(struct lcd_guiKeyPad)))
#define lcd_guiNewKeyPad(a,x,y,w,h,t,func,tg)			lcd_guiInitKeyPad(lcd_guiAllocKeyPad(a), x,y,w,h,t,func,tg)
#define lcd_guiGetKeyPadShift(a)						(a->shift)
#define lcd_guiSetKeyPadShift(a,f)						(a->shift = f)
#define lcd_guiGetKeyPadTargetField(a)					(a->targetField)


#endif /* LCD_GUI_CREATE_KEYPAD_H_ */
