//
//  lcd_gui_create_pulldown.h	  Part of GUI support library, Pull down list object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#ifndef LCD_GUI_CREATE_PULLDOWN_H_
#define LCD_GUI_CREATE_PULLDOWN_H_

#include "lcd_gui_figure.h"
#include <stddef.h>
#include "lcd_color.h"
#include "lcd_font.h"

//
//	Configuration
//
#define LCD_GUI_PULLDOWN_SIZE_W_MIN		40
#define LCD_GUI_PULLDOWN_SIZE_W_MAX		100
#define LCD_GUI_PULLDOWN_SIZE_H			24
#define LCD_GUI_PULLDOWN_COLOR_FACE		LCD_COLOR_WHITE
#define LCD_GUI_PULLDOWN_COLOR_BACK		LCD_COLOR_GRAY
#define LCD_GUI_PULLDOWN_COLOR_TOUCH	LCD_COLOR_ROYALBLUE
#define LCD_GUI_PULLDOWN_FONT			LCD_FONT_6x8

//
// Control block
//
struct lcd_guiPullDown {
	struct lcd_guiGroup grp;			// Essential item
	char				**label;
	int					number;
	int					select;
	void				(*actionProg)(struct lcd_guiPullDown *s);
	struct lcd_guiText	*caption;
};

//
//	API	- Static memory functions
//
// Initialization parameter macro
#define LCD_GUI_INIT_PULL_DOWN(next,prev,x,y,width,height,face,back,label,font,number,select,eventProg,figs,cap)	{\
		LCD_GUI_INIT_GROUP(next,prev,x,y,width,height,LCD_COLOR_TO_DARK(back),figs,lcd_guiTouchPullDown),\
		label,\
		number,\
		select,\
		eventProg,\
		cap,\
}
struct lcd_guiPullDownSet {
	struct lcd_guiPullDown	pullDown;
	struct lcd_guiParent	p;
	struct lcd_guiRect		r1;
	struct lcd_guiRect		r2;
	struct lcd_guiText		t;
};
#define LCD_GUI_INIT_PULL_DOWN_SET(name,next,prev,x,y,width,height,face,back,label,font,number,select,eventProg)	{\
		LCD_GUI_INIT_PULL_DOWN(next,prev,x,y,width,height,face,back,label,font,number,select,eventProg,&(name.p),&(name.t)),\
		LCD_GUI_INIT_PARENT(&(name.r1), NULL, NULL),\
		LCD_GUI_INIT_RECT(&(name.r2), NULL, width-1, 0, 1, height-1, LCD_COLOR_TO_LIGHT(back)),\
		LCD_GUI_INIT_RECT(&(name.t), NULL, 0, height-1, width, 1, LCD_COLOR_TO_LIGHT(back)),\
		LCD_GUI_INIT_TEXT(NULL, NULL, 1, 1, width-2, height-2, face,back,LCD_GUI_TEXT_ALIGN_CENTER,LCD_GUI_TEXT_ALIGN_CENTER,"",font),\
}
//	ex:
//		void pdFieldSub(struct lcd_guiPullDown *b) {
//			printf("Pull down Update!\n");
//		}
//		char						*label[] = {"Select1","Select2","Select3"};
//		struct lcd_guiPullDownSet	fld1 = LCD_GUI_INIT_PULL_DOWN_SET(fld1, NULL, NULL, 100, 200, 50, 25, LCD_COLOR_LIME, LCD_COLOR_GRAY, label, LCD_FONT_6x8, 3, 0, pdFieldSub);
//		struct lcd_guiRootSet		root = LCD_GUI_INIT_ROOT_SET(root, LCD_COLOR_BLACK, &fld1, NULL);


//
//	API	- Dynamic memory functions
//
//extern struct lcd_guiPullDown	*lcd_guiAllocPullDown(struct lcd_guiGroup *parent);
extern struct lcd_guiPullDown	*lcd_guiInitPullDown(struct lcd_guiPullDown *alloc, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, char **label, const struct lcd_font *font, int number, int select, void (*actionProg)(struct lcd_guiPullDown *seg));
//extern struct lcd_guiPullDown	*lcd_guiNewPullDown(struct lcd_guiGroup *parent, short x, short y, short width, short height, unsigned short faceColor, unsigned short backColor, char **label, const struct lcd_font *font, int number, int select, void (*actionProg)(struct lcd_guiPullDown *seg));
//extern int					lcd_guiGetPullDownSelect(struct lcd_guiPullDown *alloc);
extern int						lcd_guiSetPullDownSelect(struct lcd_guiPullDown *alloc, int select);


//
//	Internal
//
extern void lcd_guiTouchPullDown(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *seg);
#define lcd_guiAllocPullDown(b)								(struct lcd_guiPullDown*)lcd_guiAlloc((struct lcd_guiGroup *)(b), sizeof(struct lcd_guiPullDown))
#define lcd_guiNewPullDown(b,x,y,w,h,c1,c2,l,f,n,s,func)	lcd_guiInitPullDown(lcd_guiAllocPullDown(b),x,y,w,h,c1,c2,l,f,n,s,func)
#define lcd_guiGetPullDownSelect(g)							((g)->select)

#endif /* LCD_GUI_CREATE_PULLDOWN_H_ */
