//
//  lcd_vcd.h	Part of Graphic LCD module I/O library, Character display emulation
//  Copyright(C)2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.22 v0.0  First cording
//    2014.03.15 v0.2  Rename source file: s95160_3.h -> lcd_vcd.h
//    2017.04.15 v0.3  Supported a System Workbench for STM32
//

#ifndef LCD_VCD_H_
#define LCD_VCD_H_

#include "lcd_draw.h"					// Depend

//
// Config
//
#define VCD_FONT_WIDTH		(LCD_FONT_WIDTH)
#define VCD_FONT_HEIGHT		(LCD_FONT_HEIGHT + 2)
//#define VCD_USE_STDIO						// stdio(puts,printf...) redirect option
#define VCD_SPLIT_LINE		LCD_COLOR_GRAY	// Current display line marker

//
// Control table
//
typedef struct {
	short			x1;				// View port left-up absolute point
	short			y1;				//
	short			w;				// View port size
	short			h;				//
	short			x;				// Current relative point
	short			y;				//
	unsigned short	fcolor;			// Face
	unsigned short	bcolor;			// Back
	unsigned char	cursor;			// On or Off
} vcd_desc;

extern vcd_desc		vcd_stdout;		// Default view port

//
//	lcd_control() command code
//
#define LCD_DISP_ON                       0x0C
#define LCD_DISP_OFF                      0x08
#define LCD_DISP_BLANK                    0x0A
#define LCD_DISP_CLEAR_HOME               0x01
#define LCD_CURSOR_ON                     0x0E
#define LCD_CURSOR_OFF                    0x0C
#define LCD_CURSOR_WINK                   0x0D
#define LCD_CURSOR_BLINK                  0x0F
#define LCD_CURSOR_SH_LEFT                0x10
#define LCD_CURSOR_SH_RIGHT               0x14
#define LCD_CURSOR_HOME                   0x02
#define LCD_CURSOR_LEFT                   0x04
#define LCD_CURSOR_RIGHT                  0x06
#define LCD_PORT_MASK                     0x7F

//
// Prototype
//
extern void	vcd_char(vcd_desc *p, char ch);								// ADD 2017.04.15
extern void	vcd_print(vcd_desc *p, char *str);
extern void	vcd_position(vcd_desc *p, short column, short row);
extern void	vcd_control(vcd_desc *p, unsigned char command);
#define		vcd_color(p, color)					((p)->fcolor = (color))
#define		vcd_colors(p, face, back)			((p)->fcolor = (face), (p)->bcolor = (back))
#define		vcd_init(p, x, y, width, height)	((p)->x1=(x), (p)->y1=(y), (p)->w=(width),(p)->h=(height), (p)->x=0, (p)->y=0, (p)->fcolor=LCD_COLOR_WHITE, (p)->bcolor=LCD_COLOR_BLACK), (p)->cursor=1)

#define		lcd_char(ch)				vcd_char(&vcd_stdout,ch)		// ADD 2017.04.15
#define		lcd_print(s)				vcd_print(&vcd_stdout,s)
#define		lcd_position(c,r)			vcd_position(&vcd_stdout,c,r)
#define		lcd_control(c)				vcd_control(&vcd_stdout,c)
#define		lcd_color(c)				vcd_color(&vcd_stdout,c)
#define		lcd_colors(f,b)				vcd_colors(&vcd_stdout,f,b)

#endif /* LCD_VCD_H_ */
