//
//  s95160.h
//  Graphic LCD module "SUCCESS ELECTRONIC S95160" I/O library
//  Copyright(C)2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//	Description
//		I/O control for Graphic LCD module.
//		LCD module: SUCCESS ELECTRONIC S95160. (Controller chip is SOLOMON SYSTECH SSD1289Z)
//		Interface: 16bits 8080 parallel by software control.
//			D0-15: 16bit-port or split 2 port    default PD0-3 PE4-15
//			CS   : Any output port               default PD6
//			D/C  : Any output port               default PD7
//			WR   : Any output port               default PD8
//			RD   : Any output port               default PD9
//                 See "a95160_1.h"
//			Y-   : Any analog port               default PC1
//			X-   : Any analog port               default PC2
//			Y+   : Any analog port               default PD10
//			X+   : Any analog port               default PD11
//                 See "a95160_t1.h"
//		Screen direction:
//			X: 0=Left .. 239=Right
//			Y: 0=Top .. 319=Bottom
//		Color mode: 64k
//
//  Device: STM32F4
//      IDE     : Eclipse IDE for C/C++ Developers, Juno Service Release 1
//      Compiler: gcc-arm-none-eabi 4.7
//      Library : STM32F4xx Standard Peripherals Library Drivers (StdPeriph_Driver) V1.0.0
//
//      IDE     : AC6 OpenSTM32 System Workbench for STM32 v1.14.0
//      Library : STM32F4xx Standard Peripherals Library Drivers (StdPeriph_Driver) V1.0.0
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.22 v0.0  First cording
//    2014.02.07 v0.1  Supported a LCD_LANDSCAPE_MODE
//    2014.03.15 v0.2  Rename source file: s95160_3.h -> lcd_vcd.h
//    2014.03.15 v0.2  Rename source file: s95160_t2.h -> lcd_touch.h
//    2017.04.15 v0.3  Supported a System Workbench for STM32 and STM32CubeF4
//    2017.04.15 v0.3  Supported a STM32 NUCLEO F446RE
//

#ifndef S95160_H_
#define S95160_H_

#include "s95160_2.h"
#include "s95160_3.h"
#include "s95160_t2.h"

//
// Prototype
//
//	Character display emulation
//		printf(), puts()...  ("s95160_3.h" VCD_STDIO option)
//		void lcd_print(char *String)
//		void lcd_position(short Column, short Row)
//		void lcd_control(unsigned char Command)
//		void lcd_color(unsigned short ColorCode)
//		void lcd_colors(unsigned short FaceColor, unsigned short BackColor)
//	Character display emulation (Multi-view version)
//		void vcd_init(vcd_desc *P, short X, short Y, short Width, short Height);
//		void vcd_print(vcd_desc *P, char *String);
// 		void vcd_position(vcd_desc *P, short column, short row);
// 		void vcd_control(vcd_desc *P, unsigned char Command);
//		void vcd_color(vcd_desc *P, color);
//		void vcd_colors(vcd_desc *P, unsigned short FaceColor, unsigned short BackColor);
//	Primitive figure elements
//		void lcd_drawOpen(void);
//		void lcd_drawRect(short X, short Y, short Width, short Height, unsigned short Color);
//		void lcd_drawLine(short X1, short Y1, short X2, short Y2, short LineSize, unsigned short Color);
//		void lcd_drawImage(short X, short Y, short width, short Height, unsigned short *Image);
//		void lcd_drawChar(short X, short Y, unsigned short FaceColor, unsigned short BackColor, char Char);
//		void lcd_drawStr(short X, short Y, unsigned short FaceColor, unsigned short BackColor, char *String);
//		void lcd_drawInit(void);
//	Touch screen input
//		short lcd_touchPoint(short *X, short *Y);		// PushRate[%]
//		void  lcd_touchCalibrate(void);
//
//	Control character code
//		'\n' New line
//		'\r' Carriage return
//		'\f' Clear home
//		'\v' Cursor home
//
//	Control command
//		LCD_DISP_CLEAR_HOME
//		LCD_CURSOR_ON
//		LCD_CURSOR_OFF
//		LCD_CURSOR_HOME
//		LCD_CURSOR_LEFT
//		LCD_CURSOR_RIGHT
//
//	Color code
//		LCD_COLOR_CODE(float red, float green, float blue)
//		LCD_COLOR_BLACK
//		LCD_COLOR_DIMGRAY
//		LCD_COLOR_GRAY
//		LCD_COLOR_DARKGRAY
//		LCD_COLOR_LIGHTGRAY
//		LCD_COLOR_WHITE
//		LCD_COLOR_IVORY
//		LCD_COLOR_LAVENDER
//		LCD_COLOR_STEELBLUE
//		LCD_COLOR_DARKBLUE
//		LCD_COLOR_BLUE
//		LCD_COLOR_ROYALBLUE
//		LCD_COLOR_SKYBLUE
//		LCD_COLOR_LIGHTBLUE
//		LCD_COLOR_CYAN
//		LCD_COLOR_LIGHTCYAN
//		LCD_COLOR_DARKCYAN
//		LCD_COLOR_DARKGREEN
//		LCD_COLOR_GREEN
//		LCD_COLOR_FORESTGREEN
//		LCD_COLOR_SEAGREEN
//		LCD_COLOR_LIGHTGREEN
//		LCD_COLOR_GREENYELLOW
//		LCD_COLOR_LIME
//		LCD_COLOR_YELLOWGREEN
//		LCD_COLOR_OLIVEDRAB
//		LCD_COLOR_OLIVE
//		LCD_COLOR_TAN
//		LCD_COLOR_KHAKI
//		LCD_COLOR_YELLOW
//		LCD_COLOR_GOLD
//		LCD_COLOR_ORANGE
//		LCD_COLOR_CHOCOLATE
//		LCD_COLOR_DARKRED
//		LCD_COLOR_BROWN
//		LCD_COLOR_SALMON
//		LCD_COLOR_CORAL
//		LCD_COLOR_TOMATO
//		LCD_COLOR_RED
//		LCD_COLOR_DEEPPINK
//		LCD_COLOR_PINK
//		LCD_COLOR_MAGENTA
//		LCD_COLOR_VIOLET
//		LCD_COLOR_PURPLE
//		LCD_COLOR_INDIGO
//		LCD_COLOR_SLATEBLUE
//
//	General parameter
//		LCD_SCREEN_WIDTH	240		(LCD_LANDSCAPE_MODE=320)
//		LCD_SCREEN_HEIGHT	320		(LCD_LANDSCAPE_MODE=240)
//		LCD_FONT_WIDTH		6
//		LCD_FONT_HEIGHT		8
//
#endif /* S95160_H_ */
