//
//  s95160_1.h	Layer 1 (Physical device interface)
//  Graphic LCD module "SUCCESS ELECTRONIC S95160" I/O library
//  Copyright(C)2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.22 v0.0  First cording
//    2017.04.15 v0.3  Supported a System Workbench for STM32 and STM32CubeF4
//    2017.04.15 v0.3  Supported a STM32 NUCLEO F446RE
//

#ifndef S95160_1_H_
#define S95160_1_H_

#ifdef DELETE							// DEL START 2017.04.15
#include "stm32f4xx_gpio.h"				// Public library
#include "stm32f4xx_rcc.h"				// Public library

//
// Hardware config
//
#define LCD_CONF_DB1_GPIO		GPIOD
#define LCD_CONF_DB1_PIN		(GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_3)
#define LCD_CONF_DB2_GPIO		GPIOE
#define LCD_CONF_DB2_PIN		(GPIO_Pin_4 | GPIO_Pin_5 | GPIO_Pin_6 | GPIO_Pin_7 | GPIO_Pin_8 | GPIO_Pin_9 | GPIO_Pin_10 | GPIO_Pin_11 | GPIO_Pin_12 | GPIO_Pin_13 | GPIO_Pin_14 | GPIO_Pin_15)
#define LCD_CONF_CS_GPIO		GPIOC
#define LCD_CONF_CS_PIN			GPIO_Pin_11
#define LCD_CONF_RS_GPIO		GPIOC
#define LCD_CONF_RS_PIN			GPIO_Pin_6
#define LCD_CONF_WR_GPIO		GPIOC
#define LCD_CONF_WR_PIN			GPIO_Pin_8
#define LCD_CONF_RD_GPIO		GPIOC
#define LCD_CONF_RD_PIN			GPIO_Pin_9
#define LCD_CONF_RCCINIT()		{\
								RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOC, ENABLE);\
								RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD, ENABLE);\
								RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOE, ENABLE);}
#endif									// DEL END 2017.04.15

//
// Prototype
//
#define LCD_DC_INDEX	0				// Select the register array
#define LCD_DC_DATA		1				// Command parameter or display data

extern void				lcd_portStart(void);
//extern void			lcd_portStop(void);
extern void     		lcd_portWrite(char dc, unsigned short data);
extern unsigned short	lcd_portRead(char dc);
extern void				lcd_portWait(int ms);	// ADD 2017.04.15

#define					lcd_portIndex(a)			lcd_portWrite(LCD_DC_INDEX, a)
#define					lcd_portWriteData(a)		lcd_portWrite(LCD_DC_DATA, a)
#define					lcd_portReadData()			lcd_portRead(LCD_DC_DATA)
#define					lcd_portReadStatus()		lcd_portRead(LCD_DC_INDEX)
#define					lcd_portWriteCmd(a, b)		lcd_portWrite(LCD_DC_INDEX, a); lcd_portWrite(LCD_DC_DATA, b)

//
// Command code (index value)
//
#define LCD_COMMAND_Oscillator						0x00
#define LCD_COMMAND_DriverOutputControl				0x01
#define LCD_COMMAND_LCDDrivingWaveformControl		0x02
#define LCD_COMMAND_PowerControl1					0x03
#define LCD_COMMAND_CompareRegister1				0x05
#define LCD_COMMAND_CompareRegister2				0x06
#define LCD_COMMAND_DisplayControl					0x07
#define LCD_COMMAND_PowerControl2					0x0c
#define LCD_COMMAND_PowerControl3					0x0d
#define LCD_COMMAND_PowerControl4					0x0e
#define LCD_COMMAND_GateScanPosition				0x0f
#define LCD_COMMAND_SleepMode						0x10
#define LCD_COMMAND_EntryMode						0x11
#define LCD_COMMAND_GenericInterfaceControl			0x15
#define LCD_COMMAND_HorizontalPorch					0x16
#define LCD_COMMAND_VerticalPorch					0x17
#define LCD_COMMAND_PowerControl5					0x1e
#define LCD_COMMAND_WriteDataToGRAM					0x22
#define LCD_COMMAND_ReadDataToGRAM					0x22
#define LCD_COMMAND_RAMwriteDataMask1				0x23
#define LCD_COMMAND_RAMwriteDataMask2				0x24
#define LCD_COMMAND_FrameFrequencyControl	 		0x25
#define LCD_COMMAND_VcomOTP1						0x28
#define LCD_COMMAND_VcomOTP2						0x29
#define LCD_COMMAND_GammaControl 					0x30
#define LCD_COMMAND_GammaControl0 					0x30
#define LCD_COMMAND_GammaControl1 					0x31
#define LCD_COMMAND_GammaControl2 					0x32
#define LCD_COMMAND_GammaControl3 					0x33
#define LCD_COMMAND_GammaControl4 					0x34
#define LCD_COMMAND_GammaControl5 					0x35
#define LCD_COMMAND_GammaControl6 					0x36
#define LCD_COMMAND_GammaControl7 					0x37
#define LCD_COMMAND_GammaControl8 					0x38
#define LCD_COMMAND_GammaControl9 					0x39
#define LCD_COMMAND_GammaControl10 					0x3a
#define LCD_COMMAND_GammaControl11 					0x3b
#define LCD_COMMAND_VerticalScrollControl1	 		0x41
#define LCD_COMMAND_VerticalScrollControl2	 		0x42
#define LCD_COMMAND_HorizontalRAMaddressPosition 	0x44
#define LCD_COMMAND_VerticalRAMaddressPosition1		0x45
#define LCD_COMMAND_VerticalRAMaddressPosition2		0x46
#define LCD_COMMAND_1stScreenDrivingPosition1		0x48
#define LCD_COMMAND_1stScreenDrivingPosition2		0x49
#define LCD_COMMAND_2ndScreenDrivingPosition1		0x4a
#define LCD_COMMAND_2ndScreenDrivingPosition2		0x4b
#define LCD_COMMAND_RAMaddressSetX					0x4e
#define LCD_COMMAND_RAMaddressSetY					0x4f

#endif /* S95160_1_H_ */
