//
//  s95160_t1.h		Touch screen part, layer 1 (Physical device interface)
//  Graphic LCD module "SUCCESS ELECTRONIC S95160" I/O library
//  Copyright(C)2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2013.01.24 v0.0  First cording
//    2013.05.19 v0.0  Analog port x4 -> x2
//    2013.11.02 v0.1  Support of ADC_NOBLOCK_MODE (Conversion wait cut)
//    2013.12.23 v0.1  SMA Filter
//    2017.04.15 v0.3  Supported a System Workbench for STM32 and STM32CubeF4
//


//

#ifndef S95160_T1_H_
#define S95160_T1_H_

#ifdef DELETE							// DEL START 2017.04.15
#include "stm32f4xx_gpio.h"				// Public library
#include "stm32f4xx_adc.h"				// Public library
#include "stm32f4xx_rcc.h"				// Public library

//
// Hardware config
//
#define LCD_CONF_ADC			ADC2
#define LCD_CONF_YN_GPIO		GPIOC
#define LCD_CONF_YN_PIN			GPIO_Pin_1
#define LCD_CONF_YN_ADCH		ADC_Channel_11

#define LCD_CONF_XN_GPIO		GPIOC
#define LCD_CONF_XN_PIN			GPIO_Pin_2
#define LCD_CONF_XN_ADCH		ADC_Channel_12

//#define LCD_CONF_YP_GPIO		GPIOC			// DEL 2013.05.19
//#define LCD_CONF_YP_PIN		GPIO_Pin_4		// DEL 2013.05.19
//#define LCD_CONF_YP_ADCH		ADC_Channel_14	// DEL 2013.05.19
#define LCD_CONF_YP_GPIO		GPIOB			// ADD 2013.05.19
#define LCD_CONF_YP_PIN			GPIO_Pin_11		// ADD 2013.05.19

//#define LCD_CONF_XP_GPIO		GPIOC			// DEL 2013.05.19
//#define LCD_CONF_XP_PIN		GPIO_Pin_5		// DEL 2013.05.19
//#define LCD_CONF_XP_ADCH		ADC_Channel_15	// DEL 2013.05.19
#define LCD_CONF_XP_GPIO		GPIOB			// ADD 2013.05.19
#define LCD_CONF_XP_PIN			GPIO_Pin_12		// ADD 2013.05.19

#define LCD_CONF_RCCINIT_T1()	{\
								RCC_APB2PeriphClockCmd(RCC_APB2Periph_ADC2, ENABLE);\
		/* ADD 2013.05.19 */	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE);\
								RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOC, ENABLE);}

//
//	Parameter
//
#define ADC_TIMEOUT			10						// ADC convert wait time
//#define ADC_AVERAGE		3						// Enable average function
#define ADC_RESOLUTION		4096					// 12bit ADC config (Do not change)
#define ADC_NOCONTACT		((int)(ADC_RESOLUTION * 0.03))	// Push contact threshold 3%
#define ADC_NOCONTACT2		30						// ADD 2013.11.02 Release off threshold (Peak * %)
#define ADC_NOBLOCK_MODE							// ADD 2013.11.02
#define ADC_SAMPLE_TIME		ADC_SampleTime_56Cycles	// ADD 2013.11.02
//#define ADC_SAMPLE_TIME	ADC_SampleTime_3Cycles		// ADD 2013.11.02
//#define ADC_SAMPLE_TIME	ADC_SampleTime_144Cycles	// ADD 2013.11.02
//#define ADC_SAMPLE_TIME	ADC_SampleTime_480Cycles	// ADD 2013.11.02
#endif									// DEL END 2017.04.15
//#define ADC_AVERAGE		3						// Enable average function
#define ADC_RESOLUTION		4096					// 12bit ADC config (Do not change)
#define ADC_NOCONTACT		((int)(ADC_RESOLUTION * 0.03))	// Push contact threshold 3%
#define ADC_NOCONTACT2		30						// ADD 2013.11.02 Release off threshold (Peak * %)

//
// Prototype
//
extern void		lcd_tpStart(void);
extern void		lcd_tpGetXYZ(short point[]);	// [0]=X [1]=Y [2]=Push force, 0-4095, no adjusted value

#endif /* S95160_T1_H_ */
