//
//  bt_att_data.Heart_Rate.c
//
//  Bluetooth Protocol Stack - Attribute Database
//   <Sample data: Heart Rate>
//

#include "bt_spec_gatt.h"
#include "bt_spec_att.h"
#include "bt_att_db.h"
#include "bt_config.h"

// Alias
#define UINT16(a)  ATT_UINT16_DATA(a)       // Alias (Short name)
#define UINT32(a)  ATT_UINT32_DATA(a)       // Alias
#define UU16(a)    ATT_UUID16TO128_DATA(a)  // Alias
#define UU128(a)   ATT_UUID128_DATA(a)      // Alias

//
//  ATT Database
//
struct bt_attDb bt_attDb = {
    48,
    {// Handle  Type                                                                                  Len  Values                                                                                                                       Property
        {0x0001,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_Services_Generic_Access_Profile)},                                                                              ATT_DB_PROPERTIES_READ},
        {0x0002,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x0003), UINT16(GATT_Characteristic_Types_Device_Name)},                        ATT_DB_PROPERTIES_READ},
        {0x0003,        {UU16(GATT_Characteristic_Types_Device_Name)},                                17,  {'H','e','a','r','t',' ','R','a','t','e',' ','S','e','n','s','o','r'},                                                       ATT_DB_PROPERTIES_READ},
        {0x0004,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x0005), UINT16(GATT_Characteristic_Types_Appearance)},                         ATT_DB_PROPERTIES_READ},
        {0x0005,        {UU16(GATT_Characteristic_Types_Appearance)},                                  2,  {UINT16(GATT_Characteristic_Appearance_Category_Generic_Heart_rate_Sensor)},                                                 ATT_DB_PROPERTIES_READ},

        {0x0011,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_Services_Generic_Attribute_Profile)},                                                                           ATT_DB_PROPERTIES_READ},
        {0x0012,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read | GATT_Characteristic_Properties_Write_Without_Response | GATT_Characteristic_Properties_Indicate,
                                                                                                            UINT16(0x0013), UINT16(GATT_Characteristic_Types_Service_Changed)},                                                         ATT_DB_PROPERTIES_READ},
        {0x0013,        {UU16(GATT_Characteristic_Types_Service_Changed)},                             4,  {UINT16(0x0001), UINT16(0xffff)},                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
        {0x0014,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
        {0x0015,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},

//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x1000,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_services_heart_rate)},                                                                                             ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x1001,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Notify, UINT16(0x1002), UINT16(GATT_characteristic_heart_rate_measurement)},                 ATT_DB_PROPERTIES_READ},
        {0x1002,        {UU16(GATT_characteristic_heart_rate_measurement)},                            5,  {0b00000001, UINT16(100)},                                                                                                   0},
        {0x1003,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
        {0x1004,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ | ATT_DB_PROPERTIES_WRITE},
        {0x1005,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      20,  {'H','e','a','r','t','R','a','t','e',' ','M','e','a','s','u','r','m','e','n','t'},                                           ATT_DB_PROPERTIES_READ},
        {0x1006,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_struct, 0, UINT16(GATT_Characteristic_Unit_unitless),
                                                                                                            GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x1011,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x1012), UINT16(GATT_characteristic_body_sensor_location)},                     ATT_DB_PROPERTIES_READ},
        {0x1012,        {UU16(GATT_characteristic_body_sensor_location)},                              1,  {2}, /* Wrist */                                                                                                             ATT_DB_PROPERTIES_READ},
        {0x1013,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
        {0x1014,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ},
        {0x1015,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      20,  {'B','o','d','y',' ','S','e','n','s','o','r',' ','L','o','c','a','t','i','o','n'},                                           ATT_DB_PROPERTIES_READ},
        {0x1016,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint8, 0, UINT16(GATT_Characteristic_Unit_unitless),
                                                                                                            GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x1021,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Write, UINT16(0x1022), UINT16(GATT_characteristic_heart_rate_control_point)},                ATT_DB_PROPERTIES_READ},
        {0x1022,        {UU16(GATT_characteristic_heart_rate_control_point)},                          1,  {0x00},                                                                                                                      ATT_DB_PROPERTIES_WRITE},
        {0x1023,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Extended_Properties)},    2,  {UINT16(GATT_Characteristic_Extended_Properties_Writable_Auxiliaries)},                                                      ATT_DB_PROPERTIES_READ},
        {0x1024,        {UU16(GATT_Characteristic_Descriptors_Client_Characteristic_Configuration)},   2,  {UINT16(0x0000)},                                                                                                            ATT_DB_PROPERTIES_READ},
        {0x1025,        {UU16(GATT_Characteristic_Descriptors_Characteristic_User_Description)},      13,  {'C','o','n','t','r','o','l',' ','P','o','i','n','t'},                                                                       ATT_DB_PROPERTIES_READ},
        {0x1026,        {UU16(GATT_Characteristic_Descriptors_Characteristic_Format)},                 7,  {GATT_Characteristic_Format_uint8, 0, UINT16(GATT_Characteristic_Unit_unitless),
                                                                                                            GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers, UINT16(GATT_Characteristic_Description_Bluetooth_SIG_inside)},ATT_DB_PROPERTIES_READ},

//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2000,{UU16(GATT_Attribute_Types_Primary_Service)},                                          2,  {UINT16(GATT_services_device_information)},                                                                                  ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2001,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2002), UINT16(GATT_characteristic_manufacturer_name_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2002,        {UU16(GATT_characteristic_manufacturer_name_string)},                         16,  {'T','o','y','o','h','i','k','o',' ','T','o','g','a','s','h','i'},                                                           ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2011,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2012), UINT16(GATT_characteristic_model_number_string)},                      ATT_DB_PROPERTIES_READ},
        {0x2012,        {UU16(GATT_characteristic_model_number_string)},                              11,  {'B','T','4','P',' ','S','a','m','p','l','e'},                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2021,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2022), UINT16(GATT_characteristic_serial_number_string)},                     ATT_DB_PROPERTIES_READ},
        {0x2022,        {UU16(GATT_characteristic_serial_number_string)},                              5,  {'#','0','0','0','1'},                                                                                                       ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2031,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2032), UINT16(GATT_characteristic_hardware_revision_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2032,        {UU16(GATT_characteristic_hardware_revision_string)},                          3,  {'0','.','1'},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2041,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2042), UINT16(GATT_characteristic_firmware_revision_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2042,        {UU16(GATT_characteristic_firmware_revision_string)},                          3,  {'0','.','1'},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2051,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2052), UINT16(GATT_characteristic_software_revision_string)},                 ATT_DB_PROPERTIES_READ},
        {0x2052,        {UU16(GATT_characteristic_software_revision_string)},                          3,  {'0','.','1'},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2061,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2062), UINT16(GATT_characteristic_system_id)},                                ATT_DB_PROPERTIES_READ},
        {0x2062,        {UU16(GATT_characteristic_system_id)},                                         2,  {UINT16(123)},                                                                                                               ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2071,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2072), UINT16(GATT_characteristic_ieee_11073_20601_regulatory_certification_data_list)},ATT_DB_PROPERTIES_READ},
        {0x2072,        {UU16(GATT_characteristic_ieee_11073_20601_regulatory_certification_data_list)},1,  {0x00},                                                                                                                     ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        {0x2081,    {UU16(GATT_Attribute_Types_Characteristic)},                                       5,  {GATT_Characteristic_Properties_Read, UINT16(0x2082), UINT16(GATT_characteristic_pnp_id)},                                   ATT_DB_PROPERTIES_READ},
        {0x2082,        {UU16(GATT_characteristic_pnp_id)},                                            7,  {GATT_Characteristic_Namespace_Bluetooth_SIG_Assigned_Numbers,UINT16(999),UINT16(1),UINT16(0x0010)},                         ATT_DB_PROPERTIES_READ},
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    }
};
