//
//  bt_avdtp_acceptor.h
//
//  Bluetooth Protocol Stack - AVDTP ACP server
//  Copyright (C) 2017-2018 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          Adopted Specifications
//          Protocols
//              AVDTP A/V Distribution Transport 1.3
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2017.03.10 v0.0  First cording
//  2018.11.18 v0.4c Bug fix (AVDTP disconnect state)
//
#ifndef BT_AVDTP_ACCEPTOR_H_
#define BT_AVDTP_ACCEPTOR_H_
#include <string.h>
#include "bt_l2cap_cb_channel.h"        // Channel manage table
#include "bt_spec_avdtp.h"          	//

//
//  API
//

// Service task
extern size_t   bt_avdtpAcceptor(
        struct bt_l2capChannel *ch,     // Control block
        unsigned char          *inBuff,
        size_t                  inLen,
        unsigned char          *outBuff,
        size_t                  outSize);

// Call backs
//      Used model is "6.2 TransactionModel, Figure 6.2" Device B side
//          AVDT_XXXX_Ind and AVDT_XXXX_Rsp is it "rsp = bt_avdt_XXXX(ind)"

extern int bt_avdt_connect(int seid);									// ADD 2018.11.18
extern int bt_avdt_disconnect(int seid);								// ADD 2018.11.18
extern int bt_avdt_discover(unsigned char param[][2]);
extern int bt_avdt_getCapabilities(int seid, struct bt_avdtp_serviceCapabilitie *param, int max);
extern int bt_avdt_setConfiguration(int seid, int int_seid, struct bt_avdtp_serviceCapabilitie *param, int len);
extern int bt_avdt_getConfiguration(int seid, struct bt_avdtp_serviceCapabilitie *param, int max);
extern int bt_avdt_setReconfiguration(int seid, struct bt_avdtp_serviceCapabilitie *param, int len);
extern int bt_avdt_open(int seid);
extern int bt_avdt_start(int seid);
extern int bt_avdt_suspend(int seid);
extern int bt_avdt_close(int seid);
extern int bt_avdt_abort(int seid);
extern int bt_avdt_mediaRecieve(int seid, unsigned char *buff, int len);
extern int bt_avdt_mediaSend(int seid, unsigned char *buff, int len);	// ADD 2018.11.18

#endif /* BT_AVDTP_ACCEPTOR_H_ */
