//
//  bt_l2cap_cb_common.c
//
//  Bluetooth Protocol Stack - Common block table (entity and default values)
//  Copyright (C) 2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2017.01.18 v0.3f The new "bt_l2cap_cb_common.c" is independent of the bt_l2cap_resource_manager.c
//  2017.01.18 v0.3f Appended a authentication function for the SM
//  2017.02.11 v0.3h The new "bt_config.h"
//
#include "bt_l2cap_cb_common.h"
#include "bt_config.h"                  // ADD 2017.02.11

struct bt_l2capCommon    bt_l2capCommon = {
    
    // Policy of security (Secure Simple Pairing)
#ifdef DELETE                           // DEL START 2017.02.11
    .myIoCapability        = HCI_Parm_IO_Capability_NoInputNoOutput,
//  .myIoCapability        = HCI_Parm_IO_Capability_DisplayOnly,
//  .myIoCapability        = HCI_Parm_IO_Capability_DisplayYesNo,
//  .myIoCapability        = HCI_Parm_IO_Capability_KeyboardOnly,
//  .myAuthentication      = HCI_Parm_Authentication_Requirements_Numeric_Comparison,
//  .myAuthentication      = HCI_Parm_Authentication_Requirements_Use_IO_Capabilities,
//  .myAuthentication      = HCI_Parm_Authentication_Requirements_Dedicated_Bonding_Numeric_Comparison,
    .myAuthentication      = HCI_Parm_Authentication_Requirements_Dedicated_Bonding_Use_IO_Capabilities,
//  .myAuthentication      = HCI_Parm_Authentication_Requirements_General_Bonding_Numeric_Comparison,
//  .myAuthentication      = HCI_Parm_Authentication_Requirements_General_Bonding_Use_IO_capabilities,
#endif                                  // DEL END 2017.02.11
    .myIoCapability        = BT_SSP_IO_CAPABIRITY,          // ADD 2017.02.11
    .myAuthentication      = BT_SSP_AUTHENTICATION,         // ADD 2017.02.11
    .myOobDataPresent      = HCI_Parm_OOB_Data_Present_Not, // Not change

    // Policy of security (Security Manager)
#ifdef DELETE                           // DEL START 2017.02.11
    .responderIoCapability = SMP_IO_Capability_NoInputNoOutput,
//  .responderIoCapability = SMP_IO_Capability_DisplayOnly,
//  .responderIoCapability = SMP_IO_Capability_KeyboardOnly,
//  .responderIoCapability = SMP_IO_Capability_KeyboardDisplay,
//  .responderAuthReq      = SMP_AuthReq_Bonding,
    .responderAuthReq      = SMP_AuthReq_Bonding | SMP_AuthReq_MITM,
#endif                                  // DEL END 2017.02.11
    .responderIoCapability = BT_SMP_IO_CAPABIRITY,           // ADD 2017.02.11
    .responderAuthReq      = BT_SMP_AUTHENTICATION,          // ADD 2017.02.11
    .responderOOBDataFlag  = SMP_OOB_data_flag_Authentication_data_not_present, // Not change

    // Random seed
//  .er                    = {0xF9,0x2D,0xF2,0x3F,0xDB,0x39,0x43,0xC0,0xA4,0x95,0xB6,0x88,0x8E,0x87,0x7C,0x44}, // DEL 2017.02.11
//  .ir                    = {0xDD,0xC3,0x21,0x08,0xA3,0x26,0x47,0xD2,0x93,0x8D,0xC9,0x04,0x27,0x79,0x50,0x27}, // DEL 2017.02.11
    .er                    = {BT_SMP_KEY_ER},                                                                   // ADD 2017.02.11
    .ir                    = {BT_SMP_KEY_IR},                                                                   // ADD 2017.02.11
};
