//
//  bt_l2cap_cb_common.h
//
//  Bluetooth Protocol Stack - Common block table
//  Copyright (C) 2014-2016 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2014.02.23 v0.1a Supported the Security Manager
//  2016.04.21 v0.3d Appended a API for SSP
//  2017.01.18 v0.3f Appended a authentication function for the SM
//  2017.02.12 v0.3i Appended a Advertise on/off control and Disconnect request
//
#ifndef BT_L2CAP_CB_COMMON_H_
#define BT_L2CAP_CB_COMMON_H_

#include "bt_spec_hci.h"                    // ADD 2017.01.18
#include "bt_spec_smp.h"                    // ADD 2017.01.18

//
//  Global area
//
struct bt_l2capCommon {
    unsigned char   myBdAddr[6];
    unsigned char   myAddrType;             // ADD 2017.01.18
//  unsigned char   myAddressType;          // DEL 2017.01.18
    int             hciVersion;

    unsigned char   myIoCapability;         // ADD 2016.04.21  SSP bt_spec_hci.h
    unsigned char   myAuthentication;       // ADD 2016.04.21  SSP bt_spec_hci.h
    unsigned char   myOobDataPresent;       // ADD 2016.04.21  SSP bt_spec_hci.h

    unsigned char   rand1[8];               // ADD 2017.01.18  SM
    unsigned char   rand2[8];               // ADD 2017.01.18  SM
    unsigned char   er[16];                 // ADD 2017.01.18  SM ER root key
    unsigned char   ir[16];                 // ADD 2017.01.18  SM IR root key
    unsigned char   responderIoCapability;  // ADD 2017.01.18  SM bt_spec_smp.h
    unsigned char   responderAuthReq;       // ADD 2017.01.18  SM bt_spec_smp.h
    unsigned char   responderOOBDataFlag;   // ADD 2017.01.18  SM bt_spec_smp.h

    int             resourceManagerRequest;
    void            *resourceManagerRequestParameter;   // ADD 2017.02.12
};
extern struct bt_l2capCommon    bt_l2capCommon;

#endif /* BT_L2CAP_CB_COMMON_H_ */
