//
//  bt_l2cap_signaling.h
//
//  Bluetooth Protocol Stack - L2CAP Signaling Process
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 4.0
//          [Vol 3] Core System Package [Host volume]
//          Part A: Logical Link Control and Adaptation Protocol Specification
//              4 SIGNALING PACKET FORMATS
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2017.01.03 v0.3e argument handle -> cb_channel
//
#ifndef BT_L2CAP_SIGNALING_H_
#define BT_L2CAP_SIGNALING_H_

#include "bt_l2cap_cb_channel.h"        // Channel manage table     ADD 2017.01.03

extern size_t bt_l2capSignaling(        // Send size
//      unsigned short  handle,         // Connection handle        DEL 2017.01.03
        struct bt_l2capChannel *ch,     // Control block            ADD 2017.01.03
        unsigned char  *in,             // Recieve message
        size_t          inLen,          // Recieve message length
        unsigned char  *out,            // Send message
        size_t          maxSize         // Maxmum send message length
);

#endif /* BT_L2CAP_SIGNALING_H_ */
