//
//  bt_spec_cod.h
//
//  Bluetooth Protocol Stack - Class of Device Specification definition
//  Copyright (C) 2015 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          https://www.bluetooth.org/en-us/specification/assigned-numbers/baseband
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2015.02.11 v0.0  First cording
//
#ifndef BT_SPEC_COD_H
#define	BT_SPEC_COD_H

//
//  Major Service Classes
//
#define COS_MAJOR_Limited_Discoverable_Mode (1<<13)     //
#define COS_MAJOR_Positioning               (1<<16)     // Location identification
#define COS_MAJOR_Networking                (1<<17)     // LAN, Ad hoc, ...
#define COS_MAJOR_Rendering                 (1<<18)     // Printing, Speakers, ...
#define COS_MAJOR_Capturing                 (1<<19)     // Scanner, Microphone, ...
#define COS_MAJOR_Object_Transfer           (1<<20)     // v-Inbox, v-Folder, ...
#define COS_MAJOR_Audio                     (1<<21)     // Speaker, Microphone, Headset service, ...
#define COS_MAJOR_Telephony                 (1<<22)     // Cordless telephony, Modem, Headset service, ...
#define COS_MAJOR_Information               (1<<23)     // WEB-server, WAP-server, ...

//
//  Major Device Classes
//
#define COD_MAJOR_Miscellaneous             (0<<8)
#define COD_MAJOR_Computer                  (1<<8)      // desktop, notebook, PDA, organizer, ...
#define COD_MAJOR_Phone                     (2<<8)      // cellular, cordless, pay phone, modem, ...
#define COD_MAJOR_LAN                       (3<<8)      // Network Access point
#define COD_MAJOR_Audio_Video               (4<<8)      // headset, speaker, stereo, video display, VCR, ...
#define COD_MAJOR_Peripheral                (5<<8)      // mouse, joystick, keyboard, ...
#define COD_MAJOR_Imaging                   (6<<8)      // printer, scanner, camera, display, ...
#define COD_MAJOR_Wearable                  (7<<8)      //
#define COD_MAJOR_Toy                       (8<<8)      //
#define COD_MAJOR_Health                    (9<<8)      //
#define COD_MAJOR_Uncategorized             (15<<8)     // device code not specified


//  Minor Device Class field - Computer Major Class
#define COD_Computer_Uncategorized          (0<<2|COD_MAJOR_Computer)
#define COD_Computer_Desktop_workstation    (1<<2|COD_MAJOR_Computer)
#define COD_Computer_Server_class_computer  (2<<2|COD_MAJOR_Computer)
#define COD_Computer_Laptop                 (3<<2|COD_MAJOR_Computer)
#define COD_Computer_Handheld_PC_PDA        (4<<2|COD_MAJOR_Computer)   // clamshell
#define COD_Computer_Palm_size_PC_PDA       (5<<2|COD_MAJOR_Computer)
#define COD_Computer_Wearable_computer      (6<<2|COD_MAJOR_Computer)   // watch size
#define COD_Computer_Tablet                 (7<<2|COD_MAJOR_Computer)

//  Minor Device Class field - Phone Major Class
#define COD_Phone_Uncategorized             (0<<2|COD_MAJOR_Phone)      // code for device not assigned
#define COD_Phone_Cellular                  (1<<2|COD_MAJOR_Phone)
#define COD_Phone_Cordless                  (2<<2|COD_MAJOR_Phone)
#define COD_Phone_Smartphone                (3<<2|COD_MAJOR_Phone)
#define COD_Phone_Wired_modem               (4<<2|COD_MAJOR_Phone)
#define COD_Phone_Wired_voice_gateway       (4<<2|COD_MAJOR_Phone)
#define COD_Phone_Common_ISDN_access        (5<<2|COD_MAJOR_Phone)

//  Minor Device Class field - LAN/Network Access Point Major Class
#define COD_LAN_Fully_available             (0<<5|COD_MAJOR_LAN)
#define COD_LAN_1_to_17_utilized            (1<<5|COD_MAJOR_LAN)
#define COD_LAN_17_to_33_utilized           (2<<5|COD_MAJOR_LAN)
#define COD_LAN_33_to_50_utilized           (3<<5|COD_MAJOR_LAN)
#define COD_LAN_50_to_67_utilized           (4<<5|COD_MAJOR_LAN)
#define COD_LAN_67_to_83_utilized           (5<<5|COD_MAJOR_LAN)
#define COD_LAN_83_to_99_utilized           (6<<5|COD_MAJOR_LAN)
#define COD_LAN_No_service_available        (7<<5|COD_MAJOR_LAN)

//  Minor Device Class field - Audio/Video Major Class
#define COD_Audio_Video_Uncategorized       (0<<2|COD_MAJOR_Audio_Video)      // code not assigned
#define COD_Audio_Video_Wearable_Headset_Device (1<<2|COD_MAJOR_Audio_Video)  //
#define COD_Audio_Video_Hands_free_Device   (2<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_Reserved1           (3<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_Microphone          (4<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_Loudspeaker         (5<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_Headphones          (6<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_Portable_Audio      (7<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_Car_audio           (8<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_Set_top_box         (9<<2|COD_MAJOR_Audio_Video)      //
#define COD_Audio_Video_HiFi_Audio_Device   (10<<2|COD_MAJOR_Audio_Video)     //
#define COD_Audio_Video_VCR                 (11<<2|COD_MAJOR_Audio_Video)     //
#define COD_Audio_Video_Video_Camera        (12<<2|COD_MAJOR_Audio_Video)     //
#define COD_Audio_Video_Camcorder           (13<<2|COD_MAJOR_Audio_Video)     //
#define COD_Audio_Video_Video_Monitor       (14<<2|COD_MAJOR_Audio_Video)     //
#define COD_Audio_Video_Video_Display       (15<<2|COD_MAJOR_Audio_Video)     // and Loudspeaker
#define COD_Audio_Video_Video_Conferencing  (16<<2|COD_MAJOR_Audio_Video)     //
#define COD_Audio_Video_Reserved2           (17<<2|COD_MAJOR_Audio_Video)     //
#define COD_Audio_Video_Gaming_Toy          (18<<2|COD_MAJOR_Audio_Video)     //

//  Minor Device Class field - Peripheral Major Class
#define COD_Peripheral_Not_Keyboard_Pointing_Device     (0<<6|COD_MAJOR_Peripheral)
#define COD_Peripheral_Keyboard                         (1<<6|COD_MAJOR_Peripheral)
#define COD_Peripheral_Pointing_device                  (2<<6|COD_MAJOR_Peripheral)
#define COD_Peripheral_Combo_keyboard_pointing_device   (3<<6|COD_MAJOR_Peripheral)

#define COD_Peripheral_Uncategorized_device             (0<<2|COD_MAJOR_Peripheral)
#define COD_Peripheral_Joystick                         (1<<2|COD_MAJOR_Peripheral)
#define COD_Peripheral_Gamepad                          (2<<2|COD_MAJOR_Peripheral)
#define COD_Peripheral_Remote_control                   (3<<2|COD_MAJOR_Peripheral)
#define COD_Peripheral_Sensing_device                   (4<<2|COD_MAJOR_Peripheral)
#define COD_Peripheral_Digitizer_tablet                 (5<<2|COD_MAJOR_Peripheral)
#define COD_Peripheral_Card_Reader                      (6<<2|COD_MAJOR_Peripheral)  // e.g. SIM Card Reader
#define COD_Peripheral_Digital_Pen                      (7<<2|COD_MAJOR_Peripheral)
#define COD_Peripheral_Handheld_scanner                 (8<<2|COD_MAJOR_Peripheral)  // for bar-codes, RFID, etc.
#define COD_Peripheral_Handheld_gestural_input_device   (9<<2|COD_MAJOR_Peripheral)  // e.g., "wand" form factor)

//  Minor Device Class field - Imaging Major Class
#define COD_Imaging_Display                 (1<<4|COD_MAJOR_Imaging)
#define COD_Imaging_Camera                  (1<<5|COD_MAJOR_Imaging)
#define COD_Imaging_Scanner                 (1<<6|COD_MAJOR_Imaging)
#define COD_Imaging_Printer                 (1<<7|COD_MAJOR_Imaging)

//  Minor Device Class field - Wearable Major Class
#define COD_Wearable_Wristwatch             (1<<2|COD_MAJOR_Wearable)
#define COD_Wearable_Pager                  (2<<2|COD_MAJOR_Wearable)
#define COD_Wearable_Jacket                 (3<<2|COD_MAJOR_Wearable)
#define COD_Wearable_Helmet                 (4<<2|COD_MAJOR_Wearable)
#define COD_Wearable_Glasses                (5<<2|COD_MAJOR_Wearable)

//  Minor Device Class field - Toy Major Class
#define COD_Toy_Robot                       (1<<2|COD_MAJOR_Toy)
#define COD_Toy_Vehicle                     (2<<2|COD_MAJOR_Toy)
#define COD_Toy_Doll                        (3<<2|COD_MAJOR_Toy)    // Action figure
#define COD_Toy_Controller                  (4<<2|COD_MAJOR_Toy)
#define COD_Toy_Game                        (5<<2|COD_MAJOR_Toy)

//  Minor Device Class field - Health
#define COD_Health_Undefined                (0<<2|COD_MAJOR_Health)
#define COD_Health_Blood_Pressure_Monitor   (1<<2|COD_MAJOR_Health)
#define COD_Health_Thermometer              (2<<2|COD_MAJOR_Health)
#define COD_Health_Weighing_Scale           (3<<2|COD_MAJOR_Health)
#define COD_Health_Glucose_Meter            (4<<2|COD_MAJOR_Health)
#define COD_Health_Pulse_Oximeter           (5<<2|COD_MAJOR_Health)
#define COD_Health_Heart_Pulse_Rate_Monitor (6<<2|COD_MAJOR_Health)
#define COD_Health_Health_Data_Display      (7<<2|COD_MAJOR_Health)
#define COD_Health_Step_Counter             (8<<2|COD_MAJOR_Health)
#define COD_Health_Body_Composition_Analyzer    (9<<2|COD_MAJOR_Health)
#define COD_Health_Peak_Flow_Monitor        (10<<2|COD_MAJOR_Health)
#define COD_Health_Medication_Monitor       (11<<2|COD_MAJOR_Health)
#define COD_Health_Knee_Prosthesis          (12<<2|COD_MAJOR_Health)
#define COD_Health_Ankle_Prosthesis         (13<<2|COD_MAJOR_Health)
#define COD_Health_Generic_Health_Manager   (14<<2|COD_MAJOR_Health)
#define COD_Health_Personal_Mobility_Device (15<<2|COD_MAJOR_Health)

#endif	/* BT_SPEC_COD_H */

