//
//  bt_spec_gap.h
//
//  Bluetooth Protocol Stack - GAP(Generic Access Profile) Specification definition
//  Copyright (C) 2013 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 4.0
//          [Vol 3] Core System Package [Host volume]
//          Part C: GENERIC ACCESS PROFILE (GAP)
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//
#ifndef BT_SPEC_GAP_H_
#define BT_SPEC_GAP_H_

#include <stdint.h>

struct bt_gap_AD_Structure {
    uint8_t length;
    uint8_t AD_Type;
    uint8_t AD_Data[];
}  __attribute__ ((packed)) ;

#define GAP_AD_Type_Flags                                   0x01
#define GAP_AD_Type_16bit_Service_UUIDs_More                0x02
#define GAP_AD_Type_16bit_Service_UUIDs_Complete            0x03
#define GAP_AD_Type_32bit_Service_UUIDs_More                0x04
#define GAP_AD_Type_32bit_Service_UUIDs_Complete            0x05
#define GAP_AD_Type_128bit_Service_UUIDs_More               0x06
#define GAP_AD_Type_128bit_Service_UUIDs_Complete           0x07
#define GAP_AD_Type_Shortened_local_name                    0x08
#define GAP_AD_Type_Complete_local_name                     0x09
#define GAP_AD_Type_TX_Power_Level                          0x0a
#define GAP_AD_Type_Class_of_device                         0x0b    // 3bytes
#define GAP_AD_Type_Simple_Pairing_Hash_C                   0x0c    // 16bytes
#define GAP_AD_Type_Simple_Pairing_Randomizer_R             0x0d    // 16bytes
#define GAP_AD_Type_TK_Value                                0x10    // SECURITY MANAGER
#define GAP_AD_Type_OOB_Flags                               0x11    // SECURITY MANAGER
#define GAP_AD_Type_Slave_Connection_Interval_Range         0x12    //
#define GAP_AD_Type_Service_UUIDs_16bit                     0x14    //
#define GAP_AD_Type_Service_UUIDs_32bit                     0x15    //
#define GAP_AD_Type_Service_Data                            0x16    //
#define GAP_AD_Type_Manufacturer_Specific_Data              0xff

#define GAP_AD_Flags_LE_Limited_Discoverable_Mode           0x01
#define GAP_AD_Flags_LE_General_Discoverable_Mode           0x02
#define GAP_AD_Flags_BR_EDR_Not_Supported                   0x04
#define GAP_AD_Flags_Simultaneous_LE_BR_EDR_Controller      0x08
#define GAP_AD_Flags_Simultaneous_LE_BR_EDR_Host            0x10
#define GAP_AD_OOB_Flags_OOB_Flags_Field                    0x01    // 0 = OOB data not present, 1 = OOB data present
#define GAP_AD_OOB_Flags_LE_supported                       0x02    // Host
#define GAP_AD_OOB_Flags_Simultaneous_LE_BR_EDR             0x04    // Host
#define GAP_AD_OOB_Flags_Address_type                       0x08    // 0 = Public Address, 1 = Random Address

#endif /* BT_SPEC_GAP_H_ */
