//
//  usbh_wcc_bluetooth.c
//
//  USB Host Protocol Stack - USB Wireless controller class for bluetooth dongle
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//	Reference:
//		Bluetooth SIG (www.bluetooth.com)
//			BLUETOOTH SPECIFICATION Version 4.0
//				[Vol 4] Host Controller Interface [Transport Layer]
//				Part B: USB Transport Layer
//		STMicroelectronics
//			STM32 USB HOST Library V3.2.2 / 07-July-2015 (STM32Cube FW_F4 V1.15.0)
//
//	Device:
//		STM32Fxx
//
//	Update history
//	---------- ----- -------------------------------------------
//	2013.01.21 v0.0  First cording
//	2013.04.21 v0.1  Commit
//	2013.12.17 v0.1a Bug fix
//	2014.03.05 v0.1a Change the USB process calling
//	2017.04.23 v0.2  STM32Cube FW_F4 V1.15.0
//
#ifndef __USBH_WCC_BLUETOOTH_H
#define __USBH_WCC_BLUETOOTH_H

#include <stddef.h>
#include <time.h>
#include "usbh_core.h"

//
//	USB.org
//
#define USB_WCC_CLASS			0xe0	// Wireless controller class
#define USB_WCC_CLASS_RF		1		// Sub class / RF controller
#define USB_PROTOCOL_BLUETOOTH	1		// Bluetooth Programing Interface
#define USB_PROTOCOL_BT_AMP		4		// Bluetooth AMP Controller

//
//  Control block table
//
typedef enum {
	BT_CMD_IDLE = 0,
	BT_CMD_START,
	BT_CMD_POST,
}	BT_CmdStateTypeDef;

typedef enum {
	BT_EVT_IDLE = 0,
	BT_EVT_SYNC,
	BT_EVT_GET_DATA,
	BT_EVT_POLL,
	BT_EVT_POST_WAIT,
}	BT_EvtStateTypeDef;

typedef enum {
	BT_OUT_IDLE = 0,
	BT_OUT_START,
	BT_OUT_POST,
	BT_OUT_WAIT,
}	BT_OutStateTypeDef;

typedef enum {
	BT_IN_IDLE = 0,
	BT_IN_START,
	BT_IN_POLL,
	BT_IN_POLL_WAIT,
	BT_IN_GET,
	BT_IN_POST_WAIT,
} BT_InStateTypeDef;

typedef struct USBH_WCC_Bluetooth_CB {	//
	uint8_t			intrHcNum;			//
	uint8_t			outHcNum;			//
	uint8_t			inHcNum;			//
	uint8_t			intrEp;				//
	uint8_t			outEp;				//
	uint8_t			inEp;				//
	uint16_t		intrEpSize;			//
	uint16_t		outEpSize;			//
	uint16_t		inEpSize;			//
	BT_CmdStateTypeDef	cmdState;		//
	BT_EvtStateTypeDef	evtState;		//
	BT_OutStateTypeDef	outState;		//
	BT_InStateTypeDef	inState;		//
	time_t			cmdTimeOut;			//
	time_t			evtTimeOut;			//
	time_t			outTimeOut;			//
	time_t			inTimeOut;			//
	uint32_t		poll;				//
	uint32_t		timer;				//
	int				evtFlag;			//
	size_t			cmdBufLen;			//
	size_t			evtBufLen;			//
	size_t			outBufLen;			//
	size_t			inBufLen;			//
	unsigned char	cmdBuf[64];			// USB endpoint buffer
	unsigned char	evtBuf[16];			//
	unsigned char	outBuf[64];			//
	unsigned char	inBuf[64];			//
}	WCC_Bluetooth_HandleTypeDef;		//

//
//	Class jump table
//
extern USBH_ClassTypeDef  			USBH_wcc_bluetooth;		// ADD 2017.04.23
#define USBH_WCC_BLUETOOTH_CLASS    &USBH_wcc_bluetooth		// ADD 2017.04.23

#endif  /* __USBH_WCC_BLUETOOTH_H */
