//
//  bt_att_db.h
//
//  Bluetooth Protocol Stack - Attribute Database manager
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.04.25 v0.0  First cording
//  2014.02.23 v0.1a Sample database template
//  2014.03.07 v0.2  Change API, argument "value" is void*
//  2015.02.20 v0.3b The new "bt_att_data.c" is independent of the ATT database user data
//  2017.01.18 v0.3f Appended a authentication function for the ATT
//  2017.02.11 v0.3h The new "bt_config.h"
//
#ifndef BT_ATT_DB_H_
#define BT_ATT_DB_H_

#include <stddef.h>
#include <stdint.h>

//
//  Data format
//
struct bt_attDbEntry {
    unsigned short  handle;             //
    unsigned char   types[16];          // UUID 128bits, bluetooth byte order
    size_t          valueLen;           //
    unsigned char   value[20];          // Maximum 20, do not change
    unsigned char   properties;         //
};
#define ATT_DB_PROPERTIES_READ              0x02
#define ATT_DB_PROPERTIES_WRITE             0x08
#define ATT_DB_PROPERTIES_NOTIFY            0x10
#define ATT_DB_PROPERTIES_INDICATE          0x20
#define ATT_DB_PROPERTIES_AUTHENTICATION    0x40    // ADD 2017.01.18
#define ATT_DB_PROPERTIES_ENCRYPTION        0x80    // ADD 2017.01.18

struct bt_attDb {
    uint8_t                 entryNum;
    struct bt_attDbEntry    entry[];
};
extern struct bt_attDb bt_attDb;        // bt_att_data.c


//
//  API
//
extern struct bt_attDbEntry    *bt_attDbGetNext(int *id);
//extern struct bt_attDbEntry  *bt_attDbFind(unsigned short startHandle, unsigned short endHandle, unsigned char *types, unsigned char *value, size_t valueLen);// CHG 2014.03.07
//extern int                    bt_attDbUpdate(unsigned short handle, unsigned char *value, size_t valueLen);                                                   // CHG 2014.03.07
//extern void                   bt_attDbNotification(unsigned short handle, unsigned char *value, size_t valueLen);     // User routine                         // CHG 2014.03.07
extern struct bt_attDbEntry    *bt_attDbFind(unsigned short startHandle, unsigned short endHandle, unsigned char *types, void *value, size_t valueLen);         // CHG 2014.03.07
extern int                      bt_attDbUpdate(unsigned short handle, void *value, size_t valueLen);                                                            // CHG 2014.03.07
extern void                     bt_attDbNotification(unsigned short handle, void *value, size_t valueLen);              // User routine                         // CHG 2014.03.07


//
//  Actual data
//
//#include "bt_att_data.h"      // DEL 2017.02.11

#endif /* BT_ATT_DB_H_ */
