//
//  bt_l2cap_cb_link.h
//
//  Bluetooth Protocol Stack - BT controller link management control block operation
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2013.05.08 v0.1  Changed a control block structure, Add bt_l2capLinkGetNext()
//  2014.02.23 v0.1a Supported the Security Manager
//  2015.02.03 v0.3  Supported the PIC32
//  2015.02.06 v0.3a Supported the Secure Simple Pairing
//  2017.01.03 v0.3e Added a API (bt_l2capLinkFindByDevice,bt_l2capLinkAddByDevice)
//  2017.01.08 v0.3e Appended a authentication function for the classic services
//  2017.01.18 v0.3f Appended a authentication function for the SM
//  2017.02.12 v0.3i Appended a Advertise on/off control and Disconnect request
//  2017.03.10 v0.4  Supported an AVDTP
//
#ifndef BT_L2CAP_CB_LINK_H_
#define BT_L2CAP_CB_LINK_H_

#include <string.h>
#include "bt_l2cap_cb_device.h"
#include "bt_l2cap_cb_channel.h"        // ADD 2017.01.03

#define BT_L2CAP_MTU_SIZE   1024

//
//  Control block
//
struct bt_l2capLink {
    struct bt_l2capLink    *next;
    unsigned short          handle;         // HCI handle
    struct bt_l2capDevice  *device;         // BD_ADDR,...
    unsigned char           linkType;       //
    unsigned char           encryption;     //
    unsigned char           authentication; // ADD 2017.01.08
    unsigned char           role;           // LE

#ifdef DELETE                               // DEL START 2017.01.18
                                            // ADD START 2014.02.23
    unsigned char           shortTermKey[16];
    unsigned char           longTermKey[16];
    unsigned char           randomNumber[8];
    unsigned char           encryptionDiversifier[2];
    enum {
        BT_L2CAP_LINK_SM_IDLE = 0,
        BT_L2CAP_LINK_SM_PHASE1,
        BT_L2CAP_LINK_SM_PHASE2,
        BT_L2CAP_LINK_SM_PHASE3,
        BT_L2CAP_LINK_SM_PHASE3_SEND_LTK,
        BT_L2CAP_LINK_SM_PHASE3_SEND_EDIV,
        BT_L2CAP_LINK_SM_PHASE3_SEND_ID,
        BT_L2CAP_LINK_SM_PHASE3_SEND_ADDR,
        BT_L2CAP_LINK_SM_PHASE3_SEND_SIG,
        BT_L2CAP_LINK_SM_PHASE3_IDLE,
    }                       smState;
    unsigned char           mrand[16];
    unsigned char           sconfirm[16];
    unsigned char           mconfirm[16];
    unsigned char           pres[7];
    unsigned char           preq[7];
                                            // ADD END 2014.02.23
#else                                       // DEL END - ADD START 2017.01.18
    unsigned char           rand[8];        // Session data
    unsigned char           ediv[2];        // Session data
    unsigned char           ltk[16];
    unsigned char           irk[16];
    unsigned char           csrk[16];
//  unsigned char           initRand[8];    // Session data
//  unsigned char           initEdiv[2];    // Session data
//  unsigned char           initLtk[16];    // Session data
	unsigned char           initIrk[16];    // Session data
//  unsigned char           initCsrk[16];   // Session data
#endif                                      // ADD END 2017.01.18

    unsigned char           buff[BT_L2CAP_MTU_SIZE];    // struct bt_l2cap_Data_Packet
    size_t                  buffSize;
    size_t                  nowSize;
    size_t                  totalSize;		// ADD 2017.03.10
    size_t                  sendedSize;

    struct bt_l2capChannel  *nowChannel;    // ADD 2017.01.03  Idle process
    unsigned short          newCid;         // Dynamic allocated number
//  unsigned char           authValid;      // ADD 2015.02.06  DEL 2017.01.08
    unsigned char           reason;         // ADD 2017.02.12
};

//
//  API
//
extern struct bt_l2capLink *bt_l2capLinkGetNext(struct bt_l2capLink **id);
extern struct bt_l2capLink *bt_l2capLinkFind(unsigned char *bdAddr, unsigned short handle);
extern struct bt_l2capLink *bt_l2capLinkAdd(unsigned char *bdAddr, unsigned short handle);
extern struct bt_l2capLink *bt_l2capLinkFindByDevice(struct bt_l2capDevice *device, unsigned short handle); // ADD 2017.01.03
extern struct bt_l2capLink *bt_l2capLinkAddByDevice(struct bt_l2capDevice *device, unsigned short handle);  // ADD 2017.01.03
extern void                 bt_l2capLinkDelete(struct bt_l2capLink *p);
extern void                 bt_l2capLinkClear(void);

#endif /* BT_L2CAP_CB_LINK_H_ */
