//
//  bt_l2cap_cb_service.h
//
//  Bluetooth Protocol Stack - Service management control block operation
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.01.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2013.05.08 v0.1  Changed a control block structure
//  2015.02.03 v0.3  Supported the PIC32
//  2017.01.03 v0.3e argument handle -> cb_channel
//  2017.01.08 v0.3e Appended a authentication function for the classic services
//  2018.11.06 v0.4c Supported a notification to server APP
//
#ifndef BT_L2CAP_CB_SERVICE_H_
#define BT_L2CAP_CB_SERVICE_H_

#include <string.h>
#include "bt_l2cap_cb_channel.h"

#define BT_L2CAP_SERVICE_CID_TO_PSM                             0x0f00      // Local rule
#define BT_L2CAP_SERVICE_PERMISSIONS_Allow                      0           // ADD 2017.01.08
#define BT_L2CAP_SERVICE_PERMISSIONS_Encryption_Required        (1 << 0)    // ADD 2017.01.08  SSP Automatic confirmation
#define BT_L2CAP_SERVICE_PERMISSIONS_Authentication_Required    (1 << 1)    // ADD 2017.01.08  SSP User confirmation
#define BT_L2CAP_SERVICE_PERMISSIONS_Authorization_Required     (1 << 2)    // ADD 2017.01.08  Not supported
#define BT_L2CAP_SERVICE_SERVICEPROG_inLen_IDLE                 0           // ADD 2018.11.06  inBuff==NULL is notification
#define BT_L2CAP_SERVICE_SERVICEPROG_inLen_CONNECT              1           // ADD 2018.11.06  inBuff==NULL is notification
#define BT_L2CAP_SERVICE_SERVICEPROG_inLen_DISCONNECT           2           // ADD 2018.11.06  inBuff==NULL is notification

//
//  Control block
//
struct bt_l2capService {
    struct bt_l2capService *next;
    unsigned short          psm;
    unsigned short          permissions;                                    // ADD 2017.01.08
//  size_t                  (*serviceProg)(unsigned short handle, unsigned char *inBuff, size_t inLen, unsigned char *outBuff, size_t outSize);         // DEL 2017.01.03
    size_t                  (*serviceProg)(struct bt_l2capChannel *ch, unsigned char *inBuff, size_t inLen, unsigned char *outBuff, size_t outSize);    // ADD 2017.01.03
};

//
//  API
//
extern struct bt_l2capService  *bt_l2capServiceGetNext(struct bt_l2capService **id);    // ADD 2015.02.03
extern struct bt_l2capService  *bt_l2capServiceFind(unsigned short psm);
extern struct bt_l2capService  *bt_l2capServiceAdd(unsigned short psm);
extern void                     bt_l2capServiceDelete(struct bt_l2capService *p);
extern void                     bt_l2capServiceClear(void);                             // ADD 2015.02.03

#endif /* BT_L2CAP_CB_SERVICE_H_ */
