//
//  bt_rfcomm_server.h
//
//  Bluetooth Protocol Stack - RFCOMM Server
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 1.1
//              PartF:1 RFCOMM with TS 07.10
//              Serial Port Emulation
//          ETSI TS 07.10 standard
//              GSM 07.10 (version 6.3.0 Release 1997)
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.02.21 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2017.01.03 v0.3e argument handle -> cb_channel
//
#ifndef BT_RFCOMM_SERVER_H_
#define BT_RFCOMM_SERVER_H_
#include <string.h>
#include "bt_l2cap_cb_channel.h"        // Channel manage table     ADD 2017.01.03  

//
//  API
//
extern size_t   bt_rfcommServer(
//      unsigned short  handle,         // Communication handle     DEL 2017.01.03
        struct bt_l2capChannel *ch,     // Control block            ADD 2017.01.03
        unsigned char  *inBuff,
        size_t          inLen,
        unsigned char  *outBuff,
        size_t          outSize);

extern void     bt_rfcommServerDataRecived(
        unsigned char  *inBuff,
        size_t          inLen);

extern int      bt_rfcommServerDataSendRequest(
        unsigned char  *outBuff,
        size_t          outLen);

#endif /* BT_RFCOMM_SERVER_H_ */
