//
//  bt_sdp_server.h
//
//  Bluetooth Protocol Stack - SDP Server
//  Copyright (C) 2013-2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          BLUETOOTH SPECIFICATION Version 2.0 + EDR
//          Volume 3: Core System Package [Host volume]
//          PartB: Service Discovery Protocol (SDP) Specification
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2013.02.01 v0.0  First cording
//  2013.04.21 v0.1  Commit
//  2017.01.03 v0.3e argument handle -> cb_channel
//  2017.03.10 v0.4  Supported an AVDTP
//
#ifndef BT_SDP_SERVER_H_
#define BT_SDP_SERVER_H_

#include <string.h>
#include "bt_l2cap_cb_channel.h"        // Channel manage table     ADD 2017.01.03  

extern size_t bt_sdpServer(
//      unsigned short  handle,         // Communication handle     DEL 2017.01.03
        struct bt_l2capChannel *ch,     // Control block            ADD 2017.01.03
        unsigned char  *inBuff,
        size_t          inLen,
        unsigned char  *outBuff,
        size_t          outSize);

                                        // ADD START 2017.03.10
enum bt_sdp_flag {
    NOT_FOUND = 0,
    FOUND
};
struct bt_sdpMasterTable {
    unsigned char      *record;
    unsigned long       handle;
    enum bt_sdp_flag    flag;
};
extern struct bt_sdpMasterTable	bt_sdpMasterTable[];
extern int                      bt_sdpRecordNum;
                                        // ADD END 2017.03.10

#endif /* BT_SDP_SERVER_H_ */
