//
//  bt_spec_a2dp.h
//
//  Bluetooth Protocol Stack - A2DP (Advanced Audio Distribution Profile) Specification definition
//  Copyright (C) 2017 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//  Reference:
//      Bluetooth SIG (www.bluetooth.com)
//          Adopted Specifications
//          Traditional Profiles
//              Advanced Audio Distribution Profile (A2DP) 1.3.1
//
//  Update history
//  ---------- ----- -------------------------------------------
//  2017.03.10 v0.0  First cording
//

#ifndef BT_SPEC_A2DP_H_
#define BT_SPEC_A2DP_H_

#include <stdint.h>

//
//	Codecs
//
#define A2DP_AudioCodecID_SBC				0x00
#define A2DP_AudioCodecID_MPEG1_2_Audio		0x01
#define A2DP_AudioCodecID_MPEG2_4_AAC		0x02
#define A2DP_AudioCodecID_ATRAC_Family		0x04
#define A2DP_AudioCodecID_Non_A2DP			0xff

union bt_a2dp_CodecSpecificInformationElements {

	struct {
		uint8_t info1;
		uint8_t info2;
		uint8_t minimumBitpoolValue;
		uint8_t maximumBitpoolValue;
	} SBC;
#define A2DP_SBC_info1_SamplingFrequency_Mask	0b11110000
#define A2DP_SBC_info1_ChannelMode_Mask			0b00001111
#define A2DP_SBC_info2_BlockLength_Mask			0b11110000
#define A2DP_SBC_info2_Subbands_Mask			0b00001100
#define A2DP_SBC_info2_AllocationMethod_Mask	0b00000011
#define A2DP_SBC_SamplingFrequency_16000Hz		0b10000000
#define A2DP_SBC_SamplingFrequency_32000Hz		0b01000000
#define A2DP_SBC_SamplingFrequency_44100Hz		0b00100000
#define A2DP_SBC_SamplingFrequency_48000Hz		0b00010000
#define A2DP_SBC_ChannelMode_MONO		        0b00001000
#define A2DP_SBC_ChannelMode_DUAL_CHANNEL		0b00000100
#define A2DP_SBC_ChannelMode_STEREO		        0b00000010
#define A2DP_SBC_ChannelMode_JOINT_STEREO		0b00000001
#define A2DP_SBC_BlockLength_4					0b10000000
#define A2DP_SBC_BlockLength_8					0b01000000
#define A2DP_SBC_BlockLength_12					0b00100000
#define A2DP_SBC_BlockLength_16					0b00010000
#define A2DP_SBC_Subbands_4					    0b00001000
#define A2DP_SBC_Subbands_8					    0b00000100
#define A2DP_SBC_AllocationMethod_SNR			0b00000010
#define A2DP_SBC_AllocationMethod_Loudness		0b00000001

	struct {
		uint8_t info1;
		uint8_t info2;
		uint8_t bitRate1;
		uint8_t bitRate2;
	} MPEG1_2_Audio;
#define A2DP_MP3_info1_Layer_Mask				0b11100000
#define A2DP_MP3_info1_CRC_Mask					0b00010000
#define A2DP_MP3_info1_ChannelMode_Mask			0b00001111
#define A2DP_MP3_info2_MPF_Mask					0b01000000
#define A2DP_MP3_info2_SamplingFrequency_Mask	0b00111111
#define A2DP_MP3_bitRate1_VBR_Mask				0b10000000
#define A2DP_MP3_bitRate1_BitRate_Mask			0b01111111
#define A2DP_MP3_bitRate2_BitRate_Mask			0b11111111
#define A2DP_MP3_Layer_1						0b10000000
#define A2DP_MP3_Layer_2						0b01000000
#define A2DP_MP3_Layer_3						0b00100000
#define A2DP_MP3_ChannelMode_MONO		        0b00001000
#define A2DP_MP3_ChannelMode_DUAL_CHANNEL		0b00000100
#define A2DP_MP3_ChannelMode_STEREO		        0b00000010
#define A2DP_MP3_ChannelMode_JOINT_STEREO		0b00000001
#define A2DP_MP3_SamplingFrequency_16000Hz		0b00100000
#define A2DP_MP3_SamplingFrequency_22050Hz		0b00010000
#define A2DP_MP3_SamplingFrequency_24000Hz		0b00001000
#define A2DP_MP3_SamplingFrequency_32000Hz		0b00000100
#define A2DP_MP3_SamplingFrequency_44100Hz		0b00000010
#define A2DP_MP3_SamplingFrequency_48000Hz		0b00000001
#define A2DP_MP3_bitRate1_BitRateIndex_14		0b01000000
#define A2DP_MP3_bitRate1_BitRateIndex_13		0b00100000
#define A2DP_MP3_bitRate1_BitRateIndex_12		0b00010000
#define A2DP_MP3_bitRate1_BitRateIndex_11		0b00001000
#define A2DP_MP3_bitRate1_BitRateIndex_10		0b00000100
#define A2DP_MP3_bitRate1_BitRateIndex_9		0b00000010
#define A2DP_MP3_bitRate1_BitRateIndex_8		0b00000001
#define A2DP_MP3_bitRate2_BitRateIndex_7		0b10000000
#define A2DP_MP3_bitRate2_BitRateIndex_6		0b01000000
#define A2DP_MP3_bitRate2_BitRateIndex_5		0b00100000
#define A2DP_MP3_bitRate2_BitRateIndex_4		0b00010000
#define A2DP_MP3_bitRate2_BitRateIndex_3		0b00001000
#define A2DP_MP3_bitRate2_BitRateIndex_2		0b00000100
#define A2DP_MP3_bitRate2_BitRateIndex_1		0b00000010
#define A2DP_MP3_bitRate2_BitRateIndex_0		0b00000001

	struct {
		uint8_t objectType;
		uint8_t samplingFrequency1;
		uint8_t info1;
		uint8_t bitRate1;
		uint8_t bitRate2;
		uint8_t bitRate3;
	} MPEG2_4_AAC;
#define A2DP_AAC_info1_SamplingFrequency_Mask	0b11110000
#define A2DP_AAC_info1_Channels_Mask			0b00001100
#define A2DP_AAC_info1_SamplingFrequency2_Mask	0b11110000
#define A2DP_AAC_bitRate1_VBR_Mask				0b10000000
#define A2DP_AAC_bitRate1_BitRate_Mask			0b01111111
#define A2DP_AAC_bitRate2_BitRate_Mask			0b11111111
#define A2DP_AAC_bitRate3_BitRate_Mask			0b11111111
#define A2DP_AAC_objectType_MPEG2_AAC_LC		0b10000000
#define A2DP_AAC_objectType_MPEG4_AAC_LC		0b01000000
#define A2DP_AAC_objectType_MPEG4_AAC_LTP		0b00100000
#define A2DP_AAC_objectType_MPEG4_AAC_scalable	0b00010000
#define A2DP_AAC_samplingFrequency1_8000Hz		0b10000000
#define A2DP_AAC_samplingFrequency1_11025Hz		0b01000000
#define A2DP_AAC_samplingFrequency1_12000Hz		0b00100000
#define A2DP_AAC_samplingFrequency1_16000Hz		0b00010000
#define A2DP_AAC_samplingFrequency1_22050Hz		0b00001000
#define A2DP_AAC_samplingFrequency1_24000Hz		0b00000100
#define A2DP_AAC_samplingFrequency1_32000Hz		0b00000010
#define A2DP_AAC_samplingFrequency1_44100Hz		0b00000001
#define A2DP_AAC_samplingFrequency2_48000Hz		0b10000000
#define A2DP_AAC_samplingFrequency2_64000Hz		0b01000000
#define A2DP_AAC_samplingFrequency2_88200Hz		0b00100000
#define A2DP_AAC_samplingFrequency2_96000Hz		0b00010000
#define A2DP_AAC_Channels_1			            0b00001000
#define A2DP_AAC_Channels_2			            0b00000100

} __attribute__ ((packed)) ;



#endif // BT_SPEC_A2DP_H_
