//
//  lcd_gui_create_button.c	  Part of GUI support library, Button object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//
//

#include <stddef.h>						// NULL,...
#include "lcd_gui_create_button.h"		// My
#include "lcd_gui_manage.h"				// lcd_guiSetDurty...
#include "lcd_gui_create.h"				// lcd_guiNew...
#include "lcd_color.h"					// LCD_COLOR...

void lcd_guiSetButtonState(struct lcd_guiButton *button, int state){
	button->capSeg->color.back = button->attr.state ? button->touchedColor : button->normalColor;
	lcd_guiSetDirtys(button->capSeg);
	return;
}

void lcd_guiTouchButton(enum lcd_guiEvent event, struct lcd_guiCoordinate *touch, struct lcd_guiGroup *seg){
	struct lcd_guiButton	*button;

	button = (struct lcd_guiButton *)seg;
	switch(event){
	case LCD_GUI_EVENT_TOUCH:
		lcd_guiSetButtonState(button, button->attr.alternateMode ? (!button->attr.state) : 1);
		break;
	case LCD_GUI_EVENT_RELEASE:
		if (!button->attr.alternateMode) {
			lcd_guiSetButtonState(button, 0);
		}
		if (button->actionProg != NULL) {
			button->actionProg(button);
		}
		break;
	default:
		break;
	}
	return;
}

struct lcd_guiButton *lcd_guiInitButton(
		struct lcd_guiButton *alloc,
		short			x,
		short			y,
		short			width,
		short			height,
		char			*caption,
		const struct lcd_font *font,
		unsigned short	faceColor,
		unsigned short	backColor,
		unsigned short	touchColor,
		enum lcd_guiButtonMode	mode,
		int				state,
		void			(*actionProg)(struct lcd_guiButton *seg))
{
	unsigned short		darkColor;
	unsigned short		brightColor;
	struct lcd_guiText	*t;

	darkColor   = lcd_colorToDark(backColor);
	brightColor = lcd_colorToLight(backColor);
	lcd_guiInitGroup(&(alloc->grp), x, y, width, height, brightColor, NULL, lcd_guiTouchButton);
	lcd_guiNewRect((struct lcd_guiGroup*)alloc, width-2, 0, 2, height-2, darkColor);
	lcd_guiNewRect((struct lcd_guiGroup*)alloc, 0, height-2, width, 2, darkColor);
	t = lcd_guiNewText((struct lcd_guiGroup*)alloc, 2, 2, width-4, height-4, faceColor, backColor, LCD_GUI_TEXT_ALIGN_CENTER, LCD_GUI_TEXT_ALIGN_CENTER, caption, font);
	alloc->normalColor        = backColor;
	alloc->touchedColor       = touchColor;
	alloc->attr.alternateMode = mode;
	alloc->attr.state         = state;
	alloc->capSeg             = t;
	alloc->actionProg         = actionProg;
	lcd_guiSetButtonState(alloc, state);
	return(alloc);
}
