//
//  lcd_gui_create_keypad.c	  Part of GUI support library, Pop up key pad object
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#include <stddef.h>						// NULL,...
#include "lcd_gui_create_keypad.h"		// My
#include "lcd_gui_create.h"				// lcd_guiInitGroup()
#include "lcd_gui_create_button.h"		// lcd_guiNewButton()
#include "lcd_color.h"					// LCD_COLOR*

//
//	Screen keyboard
//
struct lcd_guiKeyPad *lcd_guiInitKeyPad(
		struct lcd_guiKeyPad *alloc,
		short			x,
		short			y,
		short			width,
		short			height,
		enum lcd_guiKeyPadType	type,
		void			(*callBack)(struct lcd_guiButton *seg),
		void			*target)
{
	const char	*cap[4][10] = {
			{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"},
			{"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P"},
			{"A", "S", "D", "F", "G", "H", "J", "K", "L", "*"},
			{"Z", "X", "C", "V", "B", "N", "M", ".", "-", "/"},
	};
	const char	*cap2[] = {"Shift", " ", " ", "Delete", "Enter"};
	const char	*cap3[4][4] = {
			{"7", "8", "9","Esc"},
			{"4", "5", "6", "-"},
			{"1", "2", "3", "+"},
			{"0", ".", "C", "="},
	};
	struct lcd_guiArea	a;
	int					i;
	int					j;

	a.x = 0;
	a.y = 0;
	lcd_guiInitGroup(&(alloc->grp), x, y, width, height, LCD_COLOR_TRANSPARENT, NULL, NULL);
	alloc->targetField = target;
	alloc->shift       = LCD_GUI_KEYPAD_SHIFT_INIT;
	switch(type) {
	case LCD_GUI_KEYPAD_TYPE_ASCII:
		a.width  = width / 10;
		a.height = height / 5;
		for(i = 0; i < 4; i++) {
			for(j = 0; j < 10; j++) {
				lcd_guiNewButton(alloc, a.x, a.y, a.width, a.height,
						(char *)cap[i][j],
						LCD_GUI_KEYPAD_FONT,
						LCD_GUI_KEYPAD_COLOR_FACE,
						LCD_GUI_KEYPAD_COLOR_BACK,
						LCD_GUI_KEYPAD_COLOR_TOUCH,
						LCD_GUI_BUTTON_MODE_MOMENTARY, 0, callBack);
				a.x += a.width;
			}
			a.y += a.height;
			a.x = 0;
		}
		a.width *= 2;
		for(j = 0; j < 5; j++) {
			lcd_guiNewButton(alloc,
					a.x, a.y, a.width, a.height,
					(char *)cap2[j],
					LCD_GUI_KEYPAD_FONT,
					LCD_GUI_KEYPAD_COLOR_FACE,
					LCD_GUI_KEYPAD_COLOR_BACK,
					LCD_GUI_KEYPAD_COLOR_TOUCH,
					(j == 0) ? LCD_GUI_BUTTON_MODE_ALTERNATE : LCD_GUI_BUTTON_MODE_MOMENTARY,
					(j == 0) ? alloc->shift : 0,
					callBack);
			a.x += a.width;
		}
		break;
	case LCD_GUI_KEYPAD_TYPE_TENKEY:
		a.width  = width  / 4;
		a.height = height / 4;

		for(i = 0; i < 4; i++) {
			for(j = 0; j < 4; j++) {
				lcd_guiNewButton(alloc,
						a.x, a.y, a.width, a.height,
						(char *)cap3[i][j],
						LCD_GUI_KEYPAD_FONT,
						LCD_GUI_KEYPAD_COLOR_FACE,
						LCD_GUI_KEYPAD_COLOR_BACK,
						LCD_GUI_KEYPAD_COLOR_TOUCH,
						LCD_GUI_BUTTON_MODE_MOMENTARY, 0, callBack);
				a.x += a.width;
			}
			a.y += a.height;
			a.x = 0;
		}
		break;
	default:
		break;
	}
	return(alloc);
}
